/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.DeferredGraphicalViewer;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;

public class ShowDragInfomationProcessor {
    private static final Insets INSETS = new Insets(2, 4, 2, 4);
    private static final int DISTANCE = 30;
    private EditPart editpart;
    private Label labelFigure;
    private int maxWidth;

    public ShowDragInfomationProcessor(EditPart editpart) {
        this.editpart = editpart;
    }

    public Label getLabelFigure() {
        return this.labelFigure;
    }

    public void setLabelFigure(Label labelFigure) {
        this.labelFigure = labelFigure;
    }

    public Label getInfomationLabel(String infomation, Point statrtPoint) {
        if (this.labelFigure == null) {
            this.labelFigure = new Label();
            this.labelFigure.setBorder((Border)new MarginBorder(new Insets(0, 3, 0, 0)){

                public void paint(IFigure figure, Graphics graphics, Insets insets) {
                    tempRect.setBounds(1.getPaintRectangle((IFigure)figure, (Insets)insets));
                    if (this.getWidth() % 2 != 0) {
                        --1.tempRect.width;
                        --1.tempRect.height;
                    }
                    tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
                    graphics.setLineWidth(this.getWidth());
                    graphics.drawRectangle(tempRect);
                }

                private int getWidth() {
                    return 1;
                }
            });
            this.labelFigure.setLabelAlignment(1);
            this.labelFigure.setOpaque(true);
            this.labelFigure.setBackgroundColor(ReportColorConstants.TableGuideFillColor);
            this.addFeedback((IFigure)this.labelFigure);
            Dimension size = FigureUtilities.getTextExtents((String)infomation, (Font)this.labelFigure.getFont());
            Dimension newSize = size.getCopy().expand(INSETS.getWidth(), INSETS.getHeight());
            this.labelFigure.setSize(newSize);
            this.maxWidth = size.width;
            this.setLabelLocation(statrtPoint);
            this.adjustLocation(statrtPoint);
        }
        return this.labelFigure;
    }

    public void removeLabelFigue() {
        if (this.labelFigure != null) {
            LayerManager lm = (LayerManager)this.editpart.getViewer().getEditPartRegistry().get(LayerManager.ID);
            if (lm == null) {
                return;
            }
            lm.getLayer((Object)"Feedback Layer").remove((IFigure)this.labelFigure);
            this.labelFigure = null;
        }
    }

    public void updateInfomation(String label, Point p) {
        if (this.labelFigure == null) {
            return;
        }
        this.labelFigure.setText(label);
        Dimension size = FigureUtilities.getTextExtents((String)label, (Font)this.labelFigure.getFont());
        Insets insets = INSETS;
        Dimension newSize = size.getCopy().expand(insets.getWidth(), insets.getHeight());
        if (size.width > this.maxWidth) {
            this.maxWidth = size.width;
        } else {
            newSize = new Dimension(this.maxWidth, size.height).expand(insets.getWidth(), insets.getHeight());
        }
        this.labelFigure.setSize(newSize);
        this.setLabelLocation(p);
        this.adjustLocation(p);
    }

    private void setLabelLocation(Point p) {
        if (this.labelFigure == null) {
            return;
        }
        this.labelFigure.translateToRelative((Translatable)p);
        this.labelFigure.setLocation(new Point(p.x, p.y - 30));
    }

    private void adjustLocation(Point statrtPoint) {
        if (this.labelFigure == null) {
            return;
        }
        org.eclipse.draw2d.geometry.Rectangle rect = this.labelFigure.getBounds();
        Dimension dim = this.getDistance(statrtPoint);
        Point p = this.labelFigure.getLocation().getCopy();
        if (dim.width < rect.width) {
            p.x -= rect.width - dim.width;
        }
        if (dim.height < rect.height + 30) {
            p.y += rect.height + 30 - dim.height;
        }
        this.labelFigure.setLocation(p);
    }

    private Dimension getDistance(Point p) {
        FigureCanvas canvas = ((DeferredGraphicalViewer)this.editpart.getViewer()).getFigureCanvas();
        Rectangle rect = canvas.getBounds();
        Dimension retValue = new Dimension(rect.width - p.x, p.y);
        if (canvas.getVerticalBar().isVisible()) {
            retValue.width -= canvas.getVerticalBar().getSize().x;
        }
        return retValue;
    }

    protected void addFeedback(IFigure figure) {
        LayerManager lm = (LayerManager)this.editpart.getViewer().getEditPartRegistry().get(LayerManager.ID);
        if (lm == null) {
            return;
        }
        lm.getLayer((Object)"Feedback Layer").add(figure);
    }
}

