/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions;

import java.util.logging.Level;
import org.eclipse.birt.report.designer.core.model.schematic.CellHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.internal.ui.command.CommandUtils;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.ContextSelectionAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableCellEditPart;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.ui.IWorkbenchPart;

public class SplitAction
extends ContextSelectionAction {
    private static final String ACTION_MSG_SPLIT_CELLS = Messages.getString((String)"SplitAction.actionMsg.splitCells");
    public static final String ID = "org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SplitAction";

    public SplitAction(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setText(ACTION_MSG_SPLIT_CELLS);
    }

    @Override
    protected boolean calculateEnabled() {
        if (this.getRowHandles().isEmpty() && this.getColumnHandles().isEmpty()) {
            return this.getTableEditPart() != null && this.cellCanSplit();
        }
        return false;
    }

    private boolean cellCanSplit() {
        CellHandleAdapter adapt;
        if (this.getSelectedObjects().size() != 1) {
            return false;
        }
        Object obj = this.getSelectedObjects().get(0);
        return obj instanceof TableCellEditPart && ((adapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(((TableCellEditPart)obj).getModel())).getRowSpan() != 1 || adapt.getColumnSpan() != 1);
    }

    public void run() {
        try {
            CommandUtils.executeCommand("org.eclipse.birt.report.designer.ui.command.splitCommand", null);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

