/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataColumnBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.dnd.DNDLocation;
import org.eclipse.birt.report.designer.internal.ui.dnd.IDropAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListBandEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementDetailHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;

public class AggDataDropAdapter
implements IDropAdapter {
    public static final String TEMPLATE = "DATA_AGG";
    public static final String TRANS_NAME = Messages.getString((String)"AggDataDropAdapter.Trans.Name");

    @Override
    public int canDrop(Object transfer, Object target, int operation, DNDLocation location) {
        boolean cfr_ignored_0 = transfer instanceof Object[];
        if (transfer.equals(TEMPLATE)) {
            if (target instanceof TableCellEditPart) {
                CellHandle cellHandle = (CellHandle)((TableCellEditPart)target).getModel();
                if (DEUtil.isReferenceElement((DesignElementHandle)cellHandle.getContainer().getContainer())) {
                    return -1;
                }
                if (cellHandle.getContainer().getContainer() instanceof TableHandle || cellHandle.getContainer().getContainer() instanceof TableGroupHandle) {
                    return 1;
                }
                if (DEUtil.getBindingHolder((DesignElementHandle)((CellHandle)((TableCellEditPart)target).getModel())) != null) {
                    return 1;
                }
                return -1;
            }
            if (target instanceof ListBandEditPart) {
                DesignElementHandle list = ((ListBandProxy)((ListBandEditPart)target).getModel()).getElemtHandle();
                if (list instanceof ListGroupHandle) {
                    list = list.getContainer();
                }
                if (DEUtil.isReferenceElement((DesignElementHandle)list)) {
                    return -1;
                }
                return 1;
            }
        }
        return 0;
    }

    @Override
    public boolean performDrop(Object transfer, Object target, int operation, DNDLocation location) {
        boolean cfr_ignored_0 = transfer instanceof Object[];
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(TRANS_NAME);
        DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(null);
        try {
            CellHandle targetElement = null;
            if (target instanceof TableCellEditPart) {
                cellHandle = (CellHandle)((TableCellEditPart)target).getModel();
                cellHandle.addElement((DesignElementHandle)dataHandle, 0);
                targetElement = cellHandle;
            } else if (target instanceof ListBandEditPart) {
                cellHandle = (ListBandProxy)((ListBandEditPart)target).getModel();
                ElementDetailHandle slot = cellHandle.getSlotHandle();
                if (slot instanceof SlotHandle) {
                    ((SlotHandle)slot).add((DesignElementHandle)dataHandle);
                } else {
                    ((PropertyHandle)slot).add((DesignElementHandle)dataHandle);
                }
                targetElement = cellHandle.getElemtHandle();
            }
            DataColumnBindingDialog dialog = new DataColumnBindingDialog(true);
            dialog.setInput((ReportItemHandle)dataHandle, null, targetElement);
            dialog.setAggreate(true);
            if (dialog.open() == 0) {
                dataHandle.setResultSetColumn(dialog.getBindingColumn().getName());
                stack.commit();
            } else {
                stack.rollback();
            }
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionHandler.handle(e);
        }
        return true;
    }
}

