/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline.providers;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.ImportCSSStyleAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.InsertAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.ReloadCssStyleAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.UseCssStyleAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.StyleBuilder;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PlatformUI;

public class StylesNodeProvider
extends DefaultNodeProvider {
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        menu.add((IAction)new InsertAction(object, Messages.getString((String)"StylesNodeProvider.action.New")));
        super.createContextMenu(sourceViewer, object, menu);
        menu.insertAfter("additions", (IContributionItem)new Separator());
        menu.insertAfter("additions", (IAction)new ImportCSSStyleAction(object));
        menu.insertAfter("additions", (IAction)new ReloadCssStyleAction(object));
        menu.insertAfter("additions", (IAction)new UseCssStyleAction(object));
    }

    public String getNodeDisplayName(Object object) {
        return STYLES;
    }

    public String getIconName(Object model) {
        return "Styles";
    }

    protected DesignElementHandle createElement(String type) throws Exception {
        DesignElementFactory factory = DesignElementFactory.getInstance();
        if ("Style".equals(type)) {
            SharedStyleHandle handle = factory.newStyle(null);
            StyleBuilder builder = new StyleBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (ReportElementHandle)handle, StyleBuilder.DLG_TITLE_NEW);
            if (builder.open() == 1) {
                return null;
            }
            return handle;
        }
        return super.createElement(type);
    }

    public Object[] getChildren(Object model) {
        ModuleHandle moduleHandle = ((SlotHandle)model).getElementHandle().getModuleHandle();
        Object[] styles = moduleHandle.getStyles().getContents().toArray();
        Arrays.sort(styles, new AlphabeticallyComparator());
        assert (moduleHandle instanceof ReportDesignHandle);
        ArrayList<CssStyleSheetHandle> cssList = new ArrayList<CssStyleSheetHandle>();
        for (CssStyleSheetHandle cssStyleHandle : ((ReportDesignHandle)moduleHandle).getAllCssStyleSheets()) {
            cssList.add(cssStyleHandle);
        }
        Object[] csses = cssList.toArray(new Object[cssList.size()]);
        Object[] stylesAndCsses = new Object[styles.length + csses.length];
        int i = 0;
        while (i < styles.length) {
            stylesAndCsses[i] = styles[i];
            ++i;
        }
        i = 0;
        while (i < csses.length) {
            stylesAndCsses[i + styles.length] = csses[i];
            ++i;
        }
        return stylesAndCsses;
    }
}

