/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.ITextDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextPropertyDescriptor
extends PropertyDescriptor {
    private int style = 0;
    protected Text text;
    private String deValue;
    private int textLimit;

    public TextPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    @Override
    public void setInput(Object handle) {
        this.input = handle;
        this.getDescriptorProvider().setInput(this.input);
    }

    @Override
    public Control createControl(Composite parent) {
        this.text = this.isFormStyle() ? FormWidgetFactory.getInstance().createText(parent, "", this.style) : new Text(parent, this.style);
        if (this.textLimit > 0) {
            this.text.setTextLimit(this.textLimit);
        }
        SelectionAdapter defaultSelectListener = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TextPropertyDescriptor.this.handleTextSelectEvent();
            }
        };
        FocusAdapter defaultFocusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TextPropertyDescriptor.this.handleTextFocusLostEvent();
            }
        };
        this.text.addSelectionListener((SelectionListener)defaultSelectListener);
        this.text.addFocusListener((FocusListener)defaultFocusListener);
        return this.text;
    }

    @Override
    public Control getControl() {
        return this.text;
    }

    public void setText(String text) {
        this.text.setText(text);
    }

    public String getText() {
        return this.text.getText();
    }

    private void refresh(String value) {
        this.text.setText(value);
    }

    protected void handleTextSelectEvent() {
        this.processAction();
    }

    protected void handleTextFocusLostEvent() {
        this.processAction();
    }

    @Override
    public void save(Object value) throws SemanticException {
        this.descriptorProvider.save(value);
    }

    private void processAction() {
        String value = this.text.getText();
        if (!value.equals(this.deValue)) {
            try {
                this.save(value);
            }
            catch (SemanticException e1) {
                this.refresh(this.deValue);
                WidgetUtil.processError((Shell)this.text.getShell(), (Exception)((Object)e1));
            }
        }
    }

    @Override
    public void load() {
        boolean stateFlag;
        this.deValue = (String)this.getDescriptorProvider().load();
        boolean bl = stateFlag = this.deValue == null == this.text.getEnabled();
        if (stateFlag) {
            this.text.setEnabled(this.deValue != null);
        }
        if (!((ITextDescriptorProvider)this.getDescriptorProvider()).isEditable()) {
            this.text.setEditable(false);
        }
        if (this.deValue == null) {
            this.deValue = "";
        }
        if (!this.text.getText().equals(this.deValue)) {
            this.refresh(this.deValue);
        }
    }

    public void setTextLimit(int limit) {
        this.textLimit = limit;
        if (this.text != null) {
            this.text.setTextLimit(limit);
        }
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.text, (boolean)isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.text.setVisible(isVisible);
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }
}

