/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.HighlightDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PreviewPropertyDescriptor;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.swt.widgets.Composite;

public class HighlightPropertyDescriptor
extends PreviewPropertyDescriptor {
    protected HighlightDescriptorProvider highlightProvider;

    public HighlightPropertyDescriptor(boolean formStyle) {
        super(formStyle);
    }

    @Override
    public void setDescriptorProvider(IDescriptorProvider provider) {
        super.setDescriptorProvider(provider);
        if (provider instanceof HighlightDescriptorProvider) {
            this.highlightProvider = (HighlightDescriptorProvider)provider;
        }
    }

    @Override
    protected void updatePreview(Object handle) {
        if (handle != null && this.highlightProvider != null) {
            String familyValue = this.highlightProvider.getFontFamily(handle);
            int sizeValue = this.highlightProvider.getFontSize(handle);
            this.previewLabel.setFontFamily(familyValue);
            this.previewLabel.setFontSize(sizeValue);
            this.previewLabel.setBold(this.highlightProvider.isBold(handle));
            this.previewLabel.setItalic(this.highlightProvider.isItalic(handle));
            this.previewLabel.setForeground(this.highlightProvider.getColor(handle));
            this.previewLabel.setBackground(this.highlightProvider.getBackgroundColor(handle));
            this.previewLabel.setUnderline(this.highlightProvider.isUnderline(handle));
            this.previewLabel.setLinethrough(this.highlightProvider.isLinethrough(handle));
            this.previewLabel.setOverline(this.highlightProvider.isOverline(handle));
            this.previewLabel.updateView();
            if (this.highlightProvider.getBackgroundColor(handle) == null && this.isFormStyle()) {
                FormWidgetFactory.getInstance().paintFormStyle((Composite)this.previewLabel);
                FormWidgetFactory.getInstance().adapt((Composite)this.previewLabel);
            }
        } else {
            this.previewLabel.restoreDefaultState();
            this.previewLabel.setForeground(ColorManager.getColor((int)-1));
            this.previewLabel.setBackground(ColorManager.getColor((int)-1));
            this.previewLabel.updateView();
            if (this.isFormStyle()) {
                FormWidgetFactory.getInstance().paintFormStyle((Composite)this.previewLabel);
                FormWidgetFactory.getInstance().adapt((Composite)this.previewLabel);
            }
        }
    }
}

