/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.RadioGroupPropertyDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RadioGroupSection
extends Section {
    protected RadioGroupPropertyDescriptor radioGroup;
    IDescriptorProvider provider;
    private int width = -1;
    private boolean fillRadioGroup = false;

    public RadioGroupSection(String labelText, Composite parent, boolean isFormStyle) {
        super(labelText, parent, isFormStyle);
    }

    @Override
    public void createSection() {
        this.getLabelControl(this.parent);
        this.getRadioGroupControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    @Override
    public void layout() {
        GridData gd = (GridData)this.radioGroup.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - 1 - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - 1 - this.placeholder;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillRadioGroup;
        }
    }

    protected RadioGroupPropertyDescriptor getRadioGroupControl(Composite parent) {
        if (this.radioGroup == null) {
            this.radioGroup = DescriptorToolkit.createRadioGroupPropertyDescriptor(this.isFormStyle);
            if (this.getProvider() != null) {
                this.radioGroup.setDescriptorProvider(this.getProvider());
            }
            this.radioGroup.createControl(parent);
            this.radioGroup.getControl().setLayoutData((Object)new GridData());
            this.radioGroup.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    RadioGroupSection.this.radioGroup = null;
                }
            });
        } else {
            this.checkParent(this.radioGroup.getControl(), parent);
        }
        return this.radioGroup;
    }

    public RadioGroupPropertyDescriptor getRadioGroupControl() {
        return this.radioGroup;
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.radioGroup != null) {
            this.radioGroup.setDescriptorProvider(provider);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setInput(Object input) {
        assert (input != null);
        this.radioGroup.setInput(input);
    }

    public boolean isFillRadioGroup() {
        return this.fillRadioGroup;
    }

    public void setFillRadioGroup(boolean fillRadioGroup) {
        this.fillRadioGroup = fillRadioGroup;
    }

    public void setFocus() {
        if (this.radioGroup != null) {
            this.radioGroup.getControl().setFocus();
        }
    }

    @Override
    public void load() {
        if (this.radioGroup != null && !this.radioGroup.getControl().isDisposed()) {
            this.radioGroup.load();
        }
    }

    @Override
    public void reset() {
        if (this.radioGroup != null && !this.radioGroup.getControl().isDisposed()) {
            this.radioGroup.reset();
        }
    }

    @Override
    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, (boolean)isHidden);
        }
        if (this.radioGroup != null) {
            this.radioGroup.setHidden(isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, (boolean)isHidden);
        }
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.radioGroup != null) {
            this.radioGroup.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }
}

