/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ooxml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.engine.layout.emitter.Image;
import org.eclipse.birt.report.engine.ooxml.IPart;
import org.eclipse.birt.report.engine.ooxml.MimeType;
import org.eclipse.birt.report.engine.ooxml.util.OOXmlUtil;

public class ImageManager {
    private static ImageManager instance;
    private Map<String, ImagePart> images = new HashMap<String, ImagePart>();
    private int imageCount = 0;

    public static ImageManager getInstance() {
        if (instance == null) {
            instance = new ImageManager();
        }
        return instance;
    }

    public boolean hasImage(String imageId) {
        return this.images.containsKey(imageId);
    }

    public ImagePart getImagePart(IPart parent, String imageId, Image imageInfo) throws IOException {
        String childUri;
        ImagePart imagePart;
        if (imageId == null) {
            imageId = Integer.toString(this.imageCount++);
        }
        if ((imagePart = this.images.get(imageId)) == null) {
            String format = imageInfo.getFormatName();
            String uri = "/media/image" + (this.images.size() + 1) + "." + format;
            MimeType mimeType = MimeType.valueOf(format.toUpperCase());
            IPart part = parent.getPart(uri, mimeType, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image");
            OutputStream partOut = part.getOutputStream();
            partOut.write(imageInfo.getData());
            imagePart = new ImagePart(imageInfo, part);
            this.images.put(imageId, imagePart);
            partOut.close();
            return imagePart;
        }
        IPart part = imagePart.getPart();
        String parentUri = parent.getAbsoluteUri();
        String relativeUri = OOXmlUtil.getRelativeUri(parentUri, childUri = part.getAbsoluteUri());
        IPart existPart = parent.getPart(relativeUri);
        if (existPart != null) {
            if (imagePart.getPart() == existPart) {
                return imagePart;
            }
            return new ImagePart(imagePart, existPart);
        }
        return new ImagePart(imagePart, parent.createPartReference(part));
    }

    public ImagePart getImagePart(IPart parent, String imageId, byte[] imageData) throws IOException {
        Image imageInfo = OOXmlUtil.getImageInfo(imageData);
        return this.getImagePart(parent, imageId, imageInfo);
    }

    public ImagePart getImagePart(String uri) {
        return this.images.get(uri);
    }

    public static class ImagePart {
        private Image imageInfo;
        private IPart part;

        public ImagePart(Image imageInfo, IPart part) {
            this.imageInfo = imageInfo;
            this.part = part;
        }

        public ImagePart(ImagePart imagePart, IPart part) {
            this.imageInfo = imagePart.getImageInfo();
            this.part = part;
        }

        public Image getImageInfo() {
            return this.imageInfo;
        }

        public IPart getPart() {
            return this.part;
        }
    }
}

