/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.FreeForm;
import org.eclipse.birt.report.model.elements.interfaces.IFreeFormModel;

public class FreeFormHandle
extends ReportItemHandle
implements IFreeFormModel {
    public FreeFormHandle(Module module, FreeForm element) {
        super(module, element);
    }

    public SlotHandle getReportItems() {
        return this.getSlot(0);
    }

    public void bringForward(ReportItemHandle content) throws SemanticException {
        if (content == null || !content.getElement().isContentOf(this.getElement())) {
            return;
        }
        int zIndex = content.getZIndex();
        if (zIndex < this.getMaximalZIndex()) {
            content.setZIndex(zIndex + 1);
        }
    }

    public void sendBackward(ReportItemHandle content) throws SemanticException {
        if (content == null || !content.getElement().isContentOf(this.getElement())) {
            return;
        }
        int zIndex = content.getZIndex();
        if (zIndex == 0) {
            return;
        }
        content.setZIndex(zIndex - 1);
    }

    public void bringToFront(ReportItemHandle content) throws SemanticException {
        int maxZIndex;
        if (content == null || !content.getElement().isContentOf(this.getElement())) {
            return;
        }
        int zIndex = content.getZIndex();
        if (zIndex < (maxZIndex = this.getMaximalZIndex())) {
            content.setZIndex(maxZIndex + 1);
        }
    }

    public void sendToBack(ReportItemHandle content) throws SemanticException {
        if (content == null || !content.getElement().isContentOf(this.getElement())) {
            return;
        }
        int zIndex = content.getZIndex();
        if (zIndex == 0) {
            return;
        }
        content.setZIndex(0);
    }

    private int getMaximalZIndex() {
        int maxZIndex = 0;
        SlotHandle slot = this.getSlot(0);
        int i = 0;
        while (i < slot.getCount()) {
            ReportItemHandle item = (ReportItemHandle)slot.get(i);
            int tmpZIndex = item.getZIndex();
            if (tmpZIndex > maxZIndex) {
                maxZIndex = tmpZIndex;
            }
            ++i;
        }
        return maxZIndex;
    }
}

