/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.processor.ElementProcessorFactory;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ParameterDialog;
import org.eclipse.birt.report.model.adapter.oda.ReportParameterAdapter;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class ParameterComboCellEditor
extends DialogCellEditor {
    private CCombo comboBox;
    private String[] items;
    private int selection;
    protected static final int defaultStyle = 0;
    private Composite composite;
    private Button btnPopup;
    private Listener listener;
    private Object obj;
    private static final int CREATE_MODE = 0;
    private static final int EDIT_MODE = 1;
    private static String UNLINKED_REPORT_PARAM = Messages.getString((String)"DataSetParametersPage.reportParam.None");
    private static Logger logger = Logger.getLogger(ParameterComboCellEditor.class.getName());

    public ParameterComboCellEditor(Composite parent) {
        super(parent);
        this.setStyle(0);
    }

    public ParameterComboCellEditor(Composite parent, String[] items) {
        this(parent, items, 0);
    }

    public ParameterComboCellEditor(Composite parent, String[] items, int style) {
        super(parent, style);
        this.setItems(items);
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] items) {
        Assert.isNotNull((Object)items);
        this.items = items;
        this.populateComboBoxItems();
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            this.comboBox.removeAll();
            int i = 0;
            while (i < this.items.length) {
                this.comboBox.add(this.items[i], i);
                ++i;
            }
            this.setValueValid(true);
            this.selection = 0;
        }
    }

    protected Control createContents(Composite cell) {
        Color bg = cell.getBackground();
        this.composite = new Composite(cell, this.getStyle());
        this.composite.setBackground(bg);
        this.composite.setLayout((Layout)new FillLayout());
        this.comboBox = new CCombo(this.composite, this.getStyle());
        this.comboBox.setBackground(bg);
        this.comboBox.setFont(cell.getFont());
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String newValue = ParameterComboCellEditor.this.comboBox.getText();
                if (newValue != null) {
                    boolean newValidState = ParameterComboCellEditor.this.isCorrect(newValue);
                    if (newValidState) {
                        ParameterComboCellEditor.this.markDirty();
                        ParameterComboCellEditor.this.doSetValue(newValue);
                    } else {
                        ParameterComboCellEditor.this.setErrorMessage(MessageFormat.format(ParameterComboCellEditor.this.getErrorMessage(), newValue.toString()));
                    }
                    ParameterComboCellEditor.this.fireApplyEditorValue();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                String newValue = ParameterComboCellEditor.this.comboBox.getText();
                if (newValue != null) {
                    boolean newValidState = ParameterComboCellEditor.this.isCorrect(newValue);
                    if (newValidState) {
                        ParameterComboCellEditor.this.markDirty();
                        ParameterComboCellEditor.this.doSetValue(newValue);
                    } else {
                        ParameterComboCellEditor.this.setErrorMessage(MessageFormat.format(ParameterComboCellEditor.this.getErrorMessage(), newValue.toString()));
                    }
                    ParameterComboCellEditor.this.fireApplyEditorValue();
                }
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (ParameterComboCellEditor.this.btnPopup != null && !ParameterComboCellEditor.this.btnPopup.isFocusControl() && Display.getCurrent().getCursorControl() != ParameterComboCellEditor.this.btnPopup) {
                    ParameterComboCellEditor.this.applyEditorValueAndDeactivate();
                    super.focusLost(e);
                }
            }
        });
        return this.composite;
    }

    void applyEditorValueAndDeactivate() {
        this.selection = this.comboBox.getSelectionIndex();
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.items[this.selection]));
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        ParameterDialog dialog = null;
        ScalarParameterHandle handle = Utility.getScalarParameter((String)this.comboBox.getText());
        boolean mode = false;
        if (handle == null) {
            handle = (ScalarParameterHandle)ElementProcessorFactory.createProcessor((String)"ScalarParameter").createElement(null);
            dialog = new ParameterDialog(cellEditorWindow.getShell(), Messages.getString((String)"ParameterGroupNodeProvider.Dialogue.ParameterNew"));
            if (this.obj instanceof OdaDataSetParameterHandle) {
                ReportParameterAdapter adapter = new ReportParameterAdapter();
                try {
                    adapter.updateLinkedReportParameter(handle, (OdaDataSetParameterHandle)this.obj);
                }
                catch (SemanticException semanticException) {
                    // empty catch block
                }
            }
            mode = false;
        } else {
            dialog = new ParameterDialog(cellEditorWindow.getShell(), Messages.getString((String)"ParameterNodeProvider.dial.title.editScalar"));
            mode = true;
        }
        handle.addListener(this.listener);
        dialog.setInput((Object)handle);
        if (dialog.open() == 0 && dialog.getResult() instanceof ParameterHandle) {
            ParameterHandle paramerHandle = (ParameterHandle)dialog.getResult();
            if (!mode) {
                SlotHandle parameterSlotHandle = Utility.getReportModuleHandle().getParameters();
                try {
                    parameterSlotHandle.add((DesignElementHandle)paramerHandle);
                    this.comboBox.add(paramerHandle.getQualifiedName());
                }
                catch (ContentException | NameException e) {
                    logger.log(Level.FINE, e.getMessage(), e);
                }
            }
            return paramerHandle.getQualifiedName();
        }
        this.setFocus();
        handle.removeListener(this.listener);
        return null;
    }

    protected void updateContents(Object value) {
        if (this.comboBox == null) {
            return;
        }
        String text = "";
        text = value != null && !value.toString().trim().equals("") ? value.toString() : UNLINKED_REPORT_PARAM;
        this.comboBox.setText(text);
    }

    public void setEnable(boolean flag) {
        this.comboBox.setEnabled(flag);
    }

    public void setInput(Object obj) {
        this.obj = obj;
    }

    public void addScalarParmeterLister(Listener listener) {
        this.listener = listener;
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    protected Object doGetValue() {
        int selection = this.comboBox.getSelectionIndex();
        if (selection == -1) {
            return this.comboBox.getText();
        }
        return this.comboBox.getItem(selection);
    }
}

