/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.mediator.IMediatorRequest;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.data.ui.datasource.DefaultDataSourceWizard;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseWizardDialog;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NewDataSourceAction
extends Action
implements UpdateAction {
    public static final String ID = "org.eclipse.birt.report.designer.ui.actions.NewDataSourceAction";

    public NewDataSourceAction() {
        this.setId(ID);
    }

    public NewDataSourceAction(String text) {
        super(text);
        this.setId(ID);
    }

    public NewDataSourceAction(String text, int style) {
        super(text, style);
        this.setId(ID);
    }

    public NewDataSourceAction(String text, ImageDescriptor image) {
        super(text, image);
        this.setId(ID);
    }

    public boolean isEnabled() {
        ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (moduleHandle == null) {
            return false;
        }
        return super.isEnabled();
    }

    public void run() {
        if (!this.isEnabled()) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"datasource.error.title.noReportDesign"), (String)Messages.getString((String)"datasource.error.msg.noReportDesign"));
            return;
        }
        if (Policy.TRACING_ACTIONS) {
            System.out.println("New data source action >> Run ...");
        }
        List existingDataSources = this.getDataSources();
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startPersistentTrans(Messages.getString((String)"datasource.new"));
        DefaultDataSourceWizard wizard = new DefaultDataSourceWizard();
        String wizardTitle = Messages.getString((String)"datasource.new");
        wizard.setWindowTitle(wizardTitle);
        BaseWizardDialog dialog = new BaseWizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            List newDataSources = this.getDataSources();
            DataSourceHandle dataSource = this.findNewDataSource(existingDataSources, newDataSources);
            stack.commit();
            ReportRequest request = new ReportRequest("create element");
            ArrayList<DataSourceHandle> selectionObjects = new ArrayList<DataSourceHandle>();
            selectionObjects.add(dataSource);
            request.setSelectionObject(selectionObjects);
            SessionHandleAdapter.getInstance().getMediator().notifyRequest((IMediatorRequest)request);
            this.notifyResult(true);
        } else {
            stack.rollback();
            this.notifyResult(false);
        }
    }

    private List getDataSources() {
        return DEUtil.getDataSources();
    }

    private DataSourceHandle findNewDataSource(List existingDataSources, List newDataSources) {
        int i = 0;
        while (i < newDataSources.size()) {
            if (!existingDataSources.contains(newDataSources.get(i))) {
                return (DataSourceHandle)newDataSources.get(i);
            }
            ++i;
        }
        return null;
    }

    public void update() {
        this.setEnabled(SessionHandleAdapter.getInstance().getReportDesignHandle() != null);
    }
}

