/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.wizards;

import java.io.File;
import org.eclipse.birt.report.designer.internal.ui.editors.wizards.NewReportPageSupport;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;

public class WizardSaveAsPage
extends WizardPage {
    private NewReportPageSupport support;
    private static final String MSG_EMPTY_FILE_LOCATION_DIRECTORY = Messages.getString((String)"WizardNewReportCreationPage.msg.empty.file.locationDirectory");
    private static final String MSG_EMPTY_FILE_NAME = Messages.getString((String)"WizardNewReportCreationPage.msg.empty.file.name");
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            WizardSaveAsPage.this.validatePage();
            WizardSaveAsPage.this.getContainer().updateButtons();
        }
    };

    public WizardSaveAsPage(String pageName) {
        super(pageName);
        this.support = new NewReportPageSupport();
    }

    public void createControl(Composite parent) {
        Composite composite = this.support.createComposite(parent);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.support.getFileNameField().setFocus();
        this.support.getFileNameField().addListener(24, this.locationModifyListener);
        this.support.getLocationPathField().addListener(24, this.locationModifyListener);
        this.setControl((Control)composite);
        UIUtil.bindHelp((Control)this.getControl(), (String)"org.eclipse.birt.cshelp.SaveReportAsWizard_ID");
    }

    public void setOriginalFile(IEditorInput input) {
        String container = ((IPathEditorInput)input).getPath().removeLastSegments(1).toOSString();
        this.support.setInitialFileLocation(container);
        this.support.setInitialFileName(input.getName());
    }

    public boolean validatePage() {
        if (this.support.getFileName().equals("")) {
            this.setErrorMessage(null);
            this.setMessage(MSG_EMPTY_FILE_NAME);
            return false;
        }
        String location = this.support.getFileLocationFullPath().toOSString();
        if (location.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(MSG_EMPTY_FILE_LOCATION_DIRECTORY);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public IPath getResult() {
        IPath path = this.support.getFileLocationFullPath().append(this.support.getFileName());
        if (ReportPlugin.getDefault().isReportDesignFile(this.support.getInitialFileName()) && !ReportPlugin.getDefault().isReportDesignFile(path.toOSString())) {
            String[] parts = this.support.getInitialFileName().split("\\.");
            path = path.addFileExtension(parts[parts.length - 1]);
        } else if (this.support.getInitialFileName().endsWith(".rpttemplate") && !path.toOSString().endsWith(".rpttemplate")) {
            path = path.addFileExtension("rpttemplate");
        }
        File file = path.toFile();
        if (file.exists()) {
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            String question = Messages.getFormattedString((String)"SaveAsDialog.overwriteQuestion", (Object[])new Object[]{path.toOSString()});
            MessageDialog d = new MessageDialog(this.getShell(), Messages.getString((String)"SaveAsDialog.Question"), null, question, 3, buttons, 0);
            int overwrite = d.open();
            switch (overwrite) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                default: {
                    return Path.EMPTY;
                }
            }
        }
        return path;
    }
}

