/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.component.Grid;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartCheckbox;
import org.eclipse.birt.chart.ui.swt.ChartSpinner;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.GridAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class AxisGridLinesSheet
extends AbstractPopupSheet
implements SelectionListener,
Listener {
    private Composite cmpContent;
    private FillChooserComposite fccLine = null;
    private ChartCheckbox btnShow = null;
    private ChartCheckbox btnTickBetweenCategory = null;
    private Group grpMajor = null;
    private Group grpMinor = null;
    private GridAttributesComposite gacMajor = null;
    private GridAttributesComposite gacMinor = null;
    private Label lblGridCount = null;
    private ChartSpinner iscGridCount = null;
    private Axis axis;
    private int angleType;
    private ChartSpinner majGridStNum;
    private Label lblGridStepNum;
    private Label lblColor;
    private Axis defAxis;

    public AxisGridLinesSheet(String title, ChartWizardContext context, Axis axis, int angleType, Axis defAxis) {
        super(title, context, true);
        this.axis = axis;
        this.angleType = angleType;
        this.defAxis = defAxis;
    }

    @Override
    protected void bindHelp(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.Gridlines_ID");
    }

    @Override
    protected Composite getComponent(Composite parent) {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.horizontalSpacing = 5;
        glContent.verticalSpacing = 5;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        GridLayout glGeneral = new GridLayout();
        glGeneral.numColumns = 10;
        glGeneral.horizontalSpacing = 5;
        glGeneral.verticalSpacing = 5;
        glGeneral.marginHeight = 4;
        glGeneral.marginWidth = 4;
        FillLayout flMajor = new FillLayout();
        this.cmpContent = new Composite(parent, 0);
        this.cmpContent.setLayout((Layout)glContent);
        this.btnShow = this.getContext().getUIFactory().createChartCheckbox(this.cmpContent, 0, this.defAxis.getLineAttributes().isVisible());
        this.btnShow.setText(Messages.getString("BaseAxisAttributeSheetImpl.Lbl.ShowAxisLine"));
        this.btnShow.setLayoutData((Object)new GridData(1808));
        this.btnShow.setSelectionState(this.axis.getLineAttributes().isSetVisible() ? (this.axis.getLineAttributes().isVisible() ? 1 : 2) : 0);
        this.btnShow.addSelectionListener((SelectionListener)this);
        if (this.isTickBetweenCategory()) {
            this.btnTickBetweenCategory = this.getContext().getUIFactory().createChartCheckbox(this.cmpContent, 0, this.defAxis.getScale().isTickBetweenCategories());
            this.btnTickBetweenCategory.setText(Messages.getString("BaseAxisAttributeSheetImpl.Lbl.IsTickBetweenCategories"));
            this.btnTickBetweenCategory.setSelectionState(this.axis.getScale().isSetTickBetweenCategories() ? (this.axis.getScale().isTickBetweenCategories() ? 1 : 2) : 0);
            this.btnTickBetweenCategory.addSelectionListener((SelectionListener)this);
            this.btnTickBetweenCategory.setEnabled(!this.axis.isSetCategoryAxis() || this.axis.isCategoryAxis());
        } else {
            new Label(this.cmpContent, 0);
        }
        this.lblColor = new Label(this.cmpContent, 0);
        GridData gdLBLColor = new GridData(4);
        this.lblColor.setLayoutData((Object)gdLBLColor);
        this.lblColor.setText(Messages.getString("BaseAxisAttributeSheetImpl.Lbl.AxisLineColor"));
        ColorDefinition clrCurrent = null;
        if (this.axis.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getAxis_LineAttributes())) {
            clrCurrent = this.axis.getLineAttributes().getColor();
        }
        this.fccLine = new FillChooserComposite(this.cmpContent, 0, this.getContext(), (Fill)clrCurrent, false, false, this.getContext().getUIFactory().supportAutoUI(), true, false, false);
        GridData gdFCCLine = new GridData(1808);
        gdFCCLine.horizontalSpan = 1;
        gdFCCLine.heightHint = this.fccLine.getPreferredSize().y;
        gdFCCLine.grabExcessVerticalSpace = false;
        this.fccLine.setLayoutData(gdFCCLine);
        this.fccLine.addListener(this);
        this.lblColor.setEnabled(this.getContext().getUIFactory().canEnableUI(this.btnShow));
        this.fccLine.setEnabled(this.getContext().getUIFactory().canEnableUI(this.btnShow));
        this.createGridSteps();
        this.grpMajor = new Group(this.cmpContent, 0);
        GridData gdGRPMajor = new GridData(768);
        this.grpMajor.setLayoutData((Object)gdGRPMajor);
        this.grpMajor.setText(Messages.getString("BaseAxisAttributeSheetImpl.Lbl.MajorGrid"));
        this.grpMajor.setLayout((Layout)flMajor);
        boolean ticksVisible = this.angleType != 3 && this.getContext().getModel().getDimension().getValue() != 2;
        this.gacMajor = new GridAttributesComposite((Composite)this.grpMajor, 0, 14, this.getContext(), this.axis.getMajorGrid(), this.axis.getOrientation().getValue(), ticksVisible, this.defAxis.getMajorGrid()){

            @Override
            protected void init(Grid grid) {
                super.init(grid);
                this.lineVisibleLabel = Messages.getString("AxisGridLinesSheet.MajorLabel.LineIsVisible");
                this.tickVisibleLabel = Messages.getString("AxisGridLinesSheet.MajorLabel.TickIsVisible");
            }
        };
        this.gacMajor.addListener(this);
        this.grpMinor = new Group(this.cmpContent, 0);
        this.grpMinor.setLayout((Layout)new FillLayout());
        GridData gdGRPMinor = new GridData(768);
        this.grpMinor.setLayoutData((Object)gdGRPMinor);
        this.grpMinor.setText(Messages.getString("BaseAxisAttributeSheetImpl.Lbl.MinorGrid"));
        this.gacMinor = new GridAttributesComposite((Composite)this.grpMinor, 0, 14, this.getContext(), this.axis.getMinorGrid(), this.axis.getOrientation().getValue(), ticksVisible, this.defAxis.getMinorGrid()){

            @Override
            protected void init(Grid grid) {
                super.init(grid);
                this.lineVisibleLabel = Messages.getString("AxisGridLinesSheet.MinorLabel.LineIsVisible");
                this.tickVisibleLabel = Messages.getString("AxisGridLinesSheet.MinorLabel.TickIsVisible");
            }
        };
        this.gacMinor.addListener(this);
        this.setStateOfMajorGrid();
        this.setStateOfMinorGrid();
        return this.cmpContent;
    }

    protected void createGridSteps() {
        this.lblGridStepNum = new Label(this.cmpContent, 0);
        GridData gdLblGridStepNum = new GridData(4);
        this.lblGridStepNum.setLayoutData((Object)gdLblGridStepNum);
        this.lblGridStepNum.setText(Messages.getString("BaseAxisDataSheetImpl.Lbl.MajorGridStepNum"));
        Composite copMajGrid = new Composite(this.cmpContent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        copMajGrid.setLayout((Layout)gl);
        this.majGridStNum = this.getContext().getUIFactory().createChartSpinner(copMajGrid, 2048, (EObject)this.getAxisForProcessing().getScale(), "majorGridsStepNumber", true);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.majGridStNum.setLayoutData((Object)gd);
        this.majGridStNum.getWidget().setMinimum(1);
        this.majGridStNum.getWidget().setSelection(this.getAxisForProcessing().getScale().getMajorGridsStepNumber());
        this.lblGridCount = new Label(this.cmpContent, 0);
        GridData gdLBLGridCount = new GridData();
        this.lblGridCount.setLayoutData((Object)gdLBLGridCount);
        this.lblGridCount.setText(Messages.getString("BaseAxisDataSheetImpl.Lbl.MinorGridCount"));
        Composite copMinGrid = new Composite(this.cmpContent, 0);
        gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        copMinGrid.setLayout((Layout)gl);
        this.iscGridCount = this.getContext().getUIFactory().createChartSpinner(copMinGrid, 2048, (EObject)this.getAxisForProcessing().getScale(), "minorGridsPerUnit", true);
        GridData gd2 = new GridData(768);
        gd2.horizontalSpan = 2;
        this.iscGridCount.setLayoutData((Object)gd2);
        this.iscGridCount.getWidget().setMinimum(1);
        this.iscGridCount.getWidget().setSelection(this.getAxisForProcessing().getScale().getMinorGridsPerUnit());
    }

    protected boolean isTickBetweenCategory() {
        return this.angleType == 1 && (!this.axis.isSetCategoryAxis() || this.axis.isCategoryAxis());
    }

    public void handleEvent(Event event) {
        if (((Object)((Object)this.fccLine)).equals(event.widget)) {
            if (event.type == 1) {
                this.getAxisForProcessing().getLineAttributes().setColor((ColorDefinition)event.data);
            }
        } else if (((Object)((Object)this.gacMajor)).equals(event.widget)) {
            boolean isUnset = event.detail == ChartUIExtensionUtil.PROPERTY_UNSET;
            switch (event.type) {
                case 1: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getAxisForProcessing().getMajorGrid().getLineAttributes(), (String)"style", (Object)event.data, (boolean)isUnset);
                    break;
                }
                case 2: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getAxisForProcessing().getMajorGrid().getLineAttributes(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
                    break;
                }
                case 3: {
                    this.getAxisForProcessing().getMajorGrid().getLineAttributes().setColor((ColorDefinition)event.data);
                    break;
                }
                case 4: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getAxisForProcessing().getMajorGrid().getLineAttributes(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                    this.setStateOfMajorGrid();
                    break;
                }
                case 6: {
                    this.getAxisForProcessing().getMajorGrid().getTickAttributes().setColor((ColorDefinition)event.data);
                    break;
                }
                case 5: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getAxisForProcessing().getMajorGrid(), (String)"tickStyle", (Object)event.data, (boolean)isUnset);
                    break;
                }
                case 7: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getAxisForProcessing().getMajorGrid().getTickAttributes(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                }
            }
        } else if (((Object)((Object)this.gacMinor)).equals(event.widget)) {
            boolean isUnset = event.detail == ChartUIExtensionUtil.PROPERTY_UNSET;
            switch (event.type) {
                case 1: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getAxisForProcessing().getMinorGrid().getLineAttributes(), (String)"style", (Object)event.data, (boolean)isUnset);
                    break;
                }
                case 2: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getAxisForProcessing().getMinorGrid().getLineAttributes(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
                    break;
                }
                case 3: {
                    this.getAxisForProcessing().getMinorGrid().getLineAttributes().setColor((ColorDefinition)event.data);
                    break;
                }
                case 4: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getAxisForProcessing().getMinorGrid().getLineAttributes(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                    this.setStateOfMinorGrid();
                    break;
                }
                case 6: {
                    this.getAxisForProcessing().getMinorGrid().getTickAttributes().setColor((ColorDefinition)event.data);
                    break;
                }
                case 5: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getAxisForProcessing().getMinorGrid(), (String)"tickStyle", (Object)event.data, (boolean)isUnset);
                    break;
                }
                case 7: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getAxisForProcessing().getMinorGrid().getTickAttributes(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                    this.setStateOfMinorGrid();
                }
            }
        }
    }

    protected void setStateOfMinorGrid() {
        boolean enabled;
        if (ChartUIUtil.is3DWallFloorSet((Chart)this.getChart())) {
            boolean bl = enabled = !this.getContext().getUIFactory().isSetInvisible((EObject)this.getAxisForProcessing().getMinorGrid().getLineAttributes());
            if (!ChartUIUtil.is3DType((Chart)this.getChart())) {
                enabled = enabled || !this.getContext().getUIFactory().isSetInvisible((EObject)this.getAxisForProcessing().getMinorGrid().getTickAttributes());
            }
        } else {
            enabled = false;
        }
        this.lblGridCount.setEnabled(enabled);
        this.iscGridCount.setEnabled(enabled);
    }

    protected void setStateOfMajorGrid() {
        boolean enabled = ChartUIUtil.is3DWallFloorSet((Chart)this.getChart()) ? !this.getContext().getUIFactory().isSetInvisible((EObject)this.getAxisForProcessing().getMajorGrid().getLineAttributes()) : false;
        this.lblGridStepNum.setEnabled(enabled);
        this.majGridStNum.setEnabled(enabled);
    }

    public void widgetSelected(SelectionEvent e) {
        Object oSource = e.getSource();
        if (e.widget == this.btnShow) {
            boolean visible = this.btnShow.getSelectionState() == 1;
            ChartElementUtil.setEObjectAttribute((EObject)this.getAxisForProcessing().getLineAttributes(), (String)"visible", (Object)visible, (this.btnShow.getSelectionState() == 0 ? 1 : 0) != 0);
            this.lblColor.setEnabled(this.getContext().getUIFactory().canEnableUI(this.btnShow));
            this.fccLine.setEnabled(this.getContext().getUIFactory().canEnableUI(this.btnShow));
        } else if (oSource.equals(this.btnTickBetweenCategory)) {
            ChartElementUtil.setEObjectAttribute((EObject)this.getAxisForProcessing().getScale(), (String)"tickBetweenCategories", (Object)(this.btnTickBetweenCategory.getSelectionState() == 1 ? 1 : 0), (this.btnTickBetweenCategory.getSelectionState() == 0 ? 1 : 0) != 0);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private Axis getAxisForProcessing() {
        return this.axis;
    }
}

