/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.util.BaseJSEvalHelper;
import org.eclipse.birt.data.engine.olap.util.DimensionJSObjectPopulator;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;

public class DimensionJSEvalHelper
extends BaseJSEvalHelper {
    protected String dimName;

    @Override
    protected void registerJSObjectPopulators() throws DataException {
        this.dimName = OlapExpressionUtil.getReferencedDimensionName(this.expr, this.queryDefn.getBindings());
        if (this.dimName != null) {
            this.register(new DimensionJSObjectPopulator(this.scope, this.dimName, this.getTargetDimensionLevelNames()));
        }
    }

    protected List getTargetDimensionLevelNames() throws DataException {
        IDimensionDefinition dimDefn = this.getTargetDimension();
        if (dimDefn == null) {
            return new ArrayList();
        }
        ArrayList<String> result = new ArrayList<String>();
        List<ILevelDefinition> levels = dimDefn.getHierarchy().get(0).getLevels();
        int j = 0;
        while (j < levels.size()) {
            ILevelDefinition level = levels.get(j);
            result.add(level.getName());
            ++j;
        }
        return result;
    }

    protected IDimensionDefinition getTargetDimension() throws DataException {
        IEdgeDefinition columnEdge = this.queryDefn.getEdge(2);
        IEdgeDefinition rowEdge = this.queryDefn.getEdge(1);
        ArrayList<IDimensionDefinition> dims = new ArrayList<IDimensionDefinition>();
        if (columnEdge != null) {
            dims.addAll(columnEdge.getDimensions());
        }
        if (rowEdge != null) {
            dims.addAll(rowEdge.getDimensions());
        }
        int i = 0;
        while (i < dims.size()) {
            IDimensionDefinition dimDefn = (IDimensionDefinition)dims.get(i);
            if (dimDefn.getName().equals(this.dimName)) {
                return dimDefn;
            }
            ++i;
        }
        return null;
    }
}

