/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.facttable;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.data.api.IComputedMeasureHelper;
import org.eclipse.birt.data.engine.olap.data.api.IDimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.api.MeasureInfo;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.document.DocumentObjectUtil;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.impl.NamingUtil;
import org.eclipse.birt.data.engine.olap.data.impl.Traversalor;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.CubePosFilterHelper;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.DimensionDivision;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTable;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableAccessor;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.IFactTableRowIterator;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.SelectedSubDimension;
import org.eclipse.birt.data.engine.olap.data.util.Bytes;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.util.filter.ICubePosFilter;
import org.eclipse.birt.data.engine.olap.util.filter.IFacttableRow;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFacttableFilterEvalHelper;

public class FactTableRowIterator
implements IFactTableRowIterator {
    private FactTable factTable;
    private MeasureInfo[] computedMeasureInfo;
    private MeasureInfo[] allMeasureInfo;
    private IDiskArray[] selectedPos;
    private int[] dimensionIndex;
    private int[] currentSubDim;
    private List[] selectedSubDim = null;
    private IDocumentObject currentSegment;
    private int[] currentPos;
    private Object[] currentMeasureValues;
    private MeasureMap currentMeasureMap;
    private Object[] currentComputedMeasureValues;
    private Traversalor traversalor;
    private StopSign stopSign;
    private int[][] selectedPosOfCurSegment;
    private IComputedMeasureHelper computedMeasureHelper;
    private List measureFilters;
    private List cubePosFilters;
    private static Logger logger = Logger.getLogger(FactTableRowIterator.class.getName());
    private IDimensionResultIterator[] allCubeDimensionResultIterators;
    private IDimension[] allCubeDimensions;
    private int[] subDimensionIndex;
    private boolean existMeasureFilter = false;
    private boolean readMeasure = false;
    private int[] measureSize;
    private Bytes lastCombinedDimensionPosition;
    private int[] lastCurrentPos;
    private boolean lastFilterResult;
    private boolean isDuplicatedRow;

    public FactTableRowIterator(FactTable factTable, String[] dimensionName, IDiskArray[] dimensionPos, StopSign stopSign) throws IOException {
        this(factTable, dimensionName, dimensionPos, null, null, stopSign);
    }

    public FactTableRowIterator(FactTable factTable, String[] dimensionName, IDiskArray[] dimensionPos, IDimension[] allCubeDimensions, IComputedMeasureHelper computedMeasureHelper, StopSign stopSign) throws IOException {
        Object[] params = new Object[]{factTable, dimensionName, dimensionPos, stopSign};
        logger.entering(FactTableRowIterator.class.getName(), "FactTableRowIterator", params);
        this.factTable = factTable;
        this.selectedPos = dimensionPos;
        this.selectedSubDim = new List[factTable.getDimensionInfo().length];
        this.selectedPosOfCurSegment = new int[factTable.getDimensionInfo().length][];
        this.stopSign = stopSign;
        this.measureFilters = new ArrayList();
        this.cubePosFilters = new ArrayList();
        if (allCubeDimensions != null) {
            this.allCubeDimensionResultIterators = new IDimensionResultIterator[allCubeDimensions.length];
        }
        this.allCubeDimensions = allCubeDimensions;
        this.computedMeasureHelper = computedMeasureHelper;
        assert (dimensionName.length == dimensionPos.length);
        int i = 0;
        while (i < this.selectedSubDim.length) {
            this.selectedSubDim[i] = new ArrayList();
            ++i;
        }
        this.dimensionIndex = new int[factTable.getDimensionInfo().length];
        Arrays.fill(this.dimensionIndex, -1);
        i = 0;
        while (i < dimensionName.length) {
            this.dimensionIndex[factTable.getDimensionIndex((String)dimensionName[i])] = i;
            ++i;
        }
        this.caculateMeasuerSize();
        this.filterSubDimension();
        this.currentPos = new int[factTable.getDimensionInfo().length];
        this.currentMeasureValues = new Object[factTable.getMeasureInfo().length];
        this.currentMeasureMap = new MeasureMap(this.factTable.getMeasureInfo());
        if (this.computedMeasureHelper != null) {
            this.computedMeasureInfo = this.computedMeasureHelper.getAllComputedMeasureInfos();
        }
        this.computeAllMeasureInfo();
        this.nextSegment();
        logger.exiting(FactTableRowIterator.class.getName(), "FactTableRowIterator");
    }

    private void filterSubDimension() throws IOException {
        DimensionDivision[] dimensionDivisions = this.factTable.getDimensionDivision();
        SelectedSubDimension selectedSubDimension = null;
        int[] selectedSubDimensionCount = new int[this.selectedSubDim.length];
        int i = 0;
        while (i < this.selectedSubDim.length) {
            int pointer = 0;
            int j = 0;
            while (j < dimensionDivisions[i].getRanges().length) {
                if (this.dimensionIndex[i] > -1) {
                    while (pointer < this.selectedPos[this.dimensionIndex[i]].size() && (Integer)this.selectedPos[this.dimensionIndex[i]].get(pointer) < dimensionDivisions[i].getRanges()[j].start) {
                        ++pointer;
                    }
                    if (pointer >= this.selectedPos[this.dimensionIndex[i]].size()) break;
                    if ((Integer)this.selectedPos[this.dimensionIndex[i]].get(pointer) <= dimensionDivisions[i].getRanges()[j].end) {
                        selectedSubDimension = new SelectedSubDimension();
                        selectedSubDimension.subDimensionIndex = j;
                        selectedSubDimension.start = pointer;
                        while (pointer < this.selectedPos[this.dimensionIndex[i]].size() && (Integer)this.selectedPos[this.dimensionIndex[i]].get(pointer) <= dimensionDivisions[i].getRanges()[j].end) {
                            ++pointer;
                        }
                        selectedSubDimension.end = pointer - 1;
                        this.selectedSubDim[i].add(selectedSubDimension);
                    }
                } else {
                    selectedSubDimension = new SelectedSubDimension();
                    selectedSubDimension.subDimensionIndex = j;
                    selectedSubDimension.start = -1;
                    selectedSubDimension.end = -1;
                    this.selectedSubDim[i].add(selectedSubDimension);
                }
                ++j;
            }
            selectedSubDimensionCount[i] = this.selectedSubDim[i].size();
            ++i;
        }
        this.traversalor = new Traversalor(selectedSubDimensionCount);
    }

    @Override
    public boolean next() throws IOException, DataException {
        while (!this.stopSign.isStopped()) {
            block11: {
                if (this.currentSegment != null) break block11;
                return false;
            }
            try {
                Bytes combinedDimensionPosition = this.currentSegment.readBytes();
                if (this.lastCombinedDimensionPosition == null) {
                    this.lastCombinedDimensionPosition = combinedDimensionPosition;
                    this.currentPos = this.factTable.getCombinedPositionCalculator().calculateDimensionPosition(this.subDimensionIndex, combinedDimensionPosition.bytesValue());
                    this.lastCurrentPos = this.currentPos;
                    this.isDuplicatedRow = false;
                } else if (this.lastCombinedDimensionPosition.equals(combinedDimensionPosition)) {
                    this.currentPos = this.lastCurrentPos;
                    this.isDuplicatedRow = true;
                } else {
                    this.lastCombinedDimensionPosition = combinedDimensionPosition;
                    this.currentPos = this.factTable.getCombinedPositionCalculator().calculateDimensionPosition(this.subDimensionIndex, combinedDimensionPosition.bytesValue());
                    this.lastCurrentPos = this.currentPos;
                    this.isDuplicatedRow = false;
                }
                this.readMeasure = false;
                if (!this.isSelectedRow()) {
                    if (this.readMeasure || this.skipMeasure()) continue;
                    break;
                }
                if (!this.readMeasure) {
                    this.readMeasure();
                }
                return true;
            }
            catch (EOFException e) {
                break;
            }
        }
        if (this.stopSign.isStopped() || !this.nextSegment()) {
            return false;
        }
        return this.next();
    }

    @Override
    public boolean isDuplicatedRow() {
        return this.isDuplicatedRow;
    }

    public Member getMember(int dimIndex, int levelIndex) throws DataException, IOException {
        try {
            return this.getLevelObject(dimIndex, levelIndex, this.getDimensionPosition(dimIndex));
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    private Member getLevelObject(int dimIndex, int levelIndex, int dimensionPosition) throws BirtException, IOException {
        this.checkAndInitDimIterator(dimIndex);
        this.allCubeDimensionResultIterators[dimIndex].seek(dimensionPosition);
        return this.allCubeDimensionResultIterators[dimIndex].getLevelMember(levelIndex);
    }

    @Override
    public void close() throws DataException, IOException {
        if (this.computedMeasureHelper != null) {
            this.computedMeasureHelper.cleanUp();
        }
        if (this.allCubeDimensionResultIterators != null) {
            int i = 0;
            while (i < this.allCubeDimensionResultIterators.length) {
                try {
                    if (this.allCubeDimensionResultIterators[i] != null) {
                        this.allCubeDimensionResultIterators[i].close();
                    }
                }
                catch (BirtException e) {
                    throw DataException.wrap(e);
                }
                ++i;
            }
        }
        if (this.currentSegment != null) {
            this.currentSegment.close();
        }
    }

    private int[] getSubDimensionIndex() {
        int[] result = new int[this.selectedSubDim.length];
        int i = 0;
        while (i < result.length) {
            result[i] = ((SelectedSubDimension)this.selectedSubDim[i].get((int)this.currentSubDim[i])).subDimensionIndex;
            ++i;
        }
        return result;
    }

    private boolean isSelectedRow() throws IOException, DataException {
        int i;
        if (!this.isDuplicatedRow) {
            i = 0;
            while (i < this.currentPos.length) {
                if (this.dimensionIndex[i] != -1 && Arrays.binarySearch(this.selectedPosOfCurSegment[i], this.currentPos[i]) < 0) {
                    this.lastFilterResult = false;
                    return false;
                }
                ++i;
            }
            i = 0;
            while (i < this.cubePosFilters.size()) {
                if (!((CubePosFilterHelper)this.cubePosFilters.get(i)).getFilterResult(this.currentPos)) {
                    this.lastFilterResult = false;
                    return false;
                }
                ++i;
            }
            this.lastFilterResult = true;
        } else if (!this.lastFilterResult) {
            return false;
        }
        if (this.existMeasureFilter) {
            this.readMeasure();
            i = 0;
            while (i < this.measureFilters.size()) {
                IJSFacttableFilterEvalHelper measureFilter = (IJSFacttableFilterEvalHelper)this.measureFilters.get(i);
                if (!measureFilter.evaluateFilter(this.currentMeasureMap)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private void caculateMeasuerSize() {
        this.measureSize = new int[this.factTable.getMeasureInfo().length];
        int i = 0;
        while (i < this.factTable.getMeasureInfo().length) {
            this.measureSize[i] = this.factTable.getMeasureInfo()[i].getDataType() == 3 ? 8 : (this.factTable.getMeasureInfo()[i].getDataType() == 2 ? 4 : -1);
            ++i;
        }
    }

    private void readMeasure() throws IOException, DataException {
        int i = 0;
        while (i < this.currentMeasureValues.length) {
            this.currentMeasureValues[i] = DocumentObjectUtil.readValue(this.currentSegment, this.factTable.getMeasureInfo()[i].getDataType());
            ++i;
        }
        this.currentMeasureMap.setMeasureValue(this.currentMeasureValues);
        if (this.computedMeasureHelper != null) {
            try {
                this.currentComputedMeasureValues = this.computedMeasureHelper.computeMeasureValues(this.currentMeasureMap);
            }
            catch (DataException e) {
                throw new DataException("data.olap.failComputeComputedMeasureValue", (Throwable)((Object)e));
            }
        }
        this.readMeasure = true;
    }

    private boolean skipMeasure() throws IOException, DataException {
        int i = 0;
        while (i < this.measureSize.length) {
            if (this.measureSize[i] <= 0) {
                DocumentObjectUtil.readValue(this.currentSegment, this.factTable.getMeasureInfo()[i].getDataType());
            } else {
                byte nullSign = this.currentSegment.readByte();
                if (nullSign != 0 && this.currentSegment.skipBytes(this.measureSize[i]) == -1) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean nextSegment() throws IOException {
        String FTSUDocName;
        do {
            if (this.stopSign.isStopped() || !this.traversalor.next()) {
                return false;
            }
            this.currentSubDim = this.traversalor.getIntArray();
            this.subDimensionIndex = this.getSubDimensionIndex();
            FTSUDocName = FactTableAccessor.FTSUDocumentObjectNamingUtil.getDocumentObjectName(NamingUtil.getFactTableName(this.factTable.getName()), this.subDimensionIndex);
        } while (!this.factTable.getDocumentManager().exist(FTSUDocName));
        if (this.currentSegment != null) {
            this.currentSegment.close();
        }
        this.currentSegment = this.factTable.getDocumentManager().openDocumentObject(FTSUDocName);
        int i = 0;
        while (i < this.dimensionIndex.length) {
            if (this.dimensionIndex[i] != -1) {
                SelectedSubDimension selectedSubDimension = (SelectedSubDimension)this.selectedSubDim[i].get(this.currentSubDim[i]);
                this.selectedPosOfCurSegment[i] = new int[selectedSubDimension.end - selectedSubDimension.start + 1];
                int j = 0;
                while (j < selectedSubDimension.end - selectedSubDimension.start + 1) {
                    this.selectedPosOfCurSegment[i][j] = (Integer)this.selectedPos[this.dimensionIndex[i]].get(selectedSubDimension.start + j);
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public int getDimensionCount() {
        return this.factTable.getDimensionInfo().length;
    }

    @Override
    public int getDimensionIndex(String dimensionName) {
        return this.factTable.getDimensionIndex(dimensionName);
    }

    @Override
    public int getMeasureIndex(String measureName) {
        int reValue = this.factTable.getMeasureIndex(measureName);
        if (reValue < 0 && this.computedMeasureInfo != null) {
            int i = 0;
            while (i < this.computedMeasureInfo.length) {
                if (measureName.equals(this.computedMeasureInfo[i].getMeasureName())) {
                    reValue = i + this.factTable.getMeasureInfo().length;
                    break;
                }
                ++i;
            }
        }
        return reValue;
    }

    @Override
    public int getDimensionPosition(int dimensionIndex) {
        return this.currentPos[dimensionIndex];
    }

    @Override
    public int[] getDimensionPosition() {
        return this.currentPos;
    }

    @Override
    public int getMeasureCount() {
        if (this.computedMeasureInfo != null) {
            return this.factTable.getMeasureInfo().length + this.computedMeasureInfo.length;
        }
        return this.factTable.getMeasureInfo().length;
    }

    @Override
    public Object getMeasure(int measureIndex) {
        if (measureIndex < this.currentMeasureValues.length) {
            return this.currentMeasureValues[measureIndex];
        }
        if (this.currentComputedMeasureValues != null && measureIndex - this.currentMeasureValues.length < this.currentComputedMeasureValues.length) {
            return this.currentComputedMeasureValues[measureIndex - this.currentMeasureValues.length];
        }
        return null;
    }

    @Override
    public MeasureInfo[] getMeasureInfos() {
        return this.allMeasureInfo;
    }

    public void addMeasureFilter(IJSFacttableFilterEvalHelper measureFilter) {
        this.measureFilters.add(measureFilter);
        this.existMeasureFilter = true;
    }

    public void addCubePosFilter(ICubePosFilter cubePosFilter) {
        this.cubePosFilters.add(new CubePosFilterHelper(this.factTable, cubePosFilter));
    }

    private void computeAllMeasureInfo() {
        int len = this.factTable.getMeasureInfo().length;
        if (this.computedMeasureInfo != null) {
            len += this.computedMeasureInfo.length;
        }
        this.allMeasureInfo = new MeasureInfo[len];
        System.arraycopy(this.factTable.getMeasureInfo(), 0, this.allMeasureInfo, 0, this.factTable.getMeasureInfo().length);
        if (this.computedMeasureInfo != null) {
            System.arraycopy(this.computedMeasureInfo, 0, this.allMeasureInfo, this.factTable.getMeasureInfo().length, this.computedMeasureInfo.length);
        }
    }

    void checkAndInitDimIterator(int index) throws IOException {
        if (this.allCubeDimensionResultIterators[index] != null) {
            return;
        }
        this.allCubeDimensionResultIterators[index] = new DimensionResultIterator((Dimension)this.allCubeDimensions[index], this.allCubeDimensions[index].findAll(), this.stopSign);
    }

    class MeasureMap
    implements IFacttableRow {
        private MeasureInfo[] measureInfos = null;
        private Object[] measureValues = null;

        MeasureMap(MeasureInfo[] measureInfo) {
            this.measureInfos = measureInfo;
        }

        void setMeasureValue(Object[] measureValues) {
            this.measureValues = measureValues;
        }

        @Override
        public Object getMeasureValue(String measureName) {
            int i = 0;
            while (i < this.measureInfos.length) {
                if (this.measureInfos[i].getMeasureName().equals(measureName)) {
                    return this.measureValues[i];
                }
                ++i;
            }
            return null;
        }

        @Override
        public Object getLevelAttributeValue(String dimensionName, String levelName, String attributeName) throws DataException, IOException {
            Member member;
            int dimensionIndex = FactTableRowIterator.this.getDimensionIndex(dimensionName);
            if (dimensionIndex < 0) {
                return null;
            }
            try {
                member = this.getLevelMember(dimensionIndex, levelName);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
            FactTableRowIterator.this.checkAndInitDimIterator(dimensionIndex);
            int attributeIndex = FactTableRowIterator.this.allCubeDimensionResultIterators[dimensionIndex].getLevelAttributeIndex(levelName, attributeName);
            if (member != null && attributeIndex >= 0) {
                return member.getAttributes()[attributeIndex];
            }
            return null;
        }

        @Override
        public Object[] getLevelKeyValue(String dimensionName, String levelName) throws DataException, IOException {
            Member member;
            try {
                member = this.getLevelMember(dimensionName, levelName);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
            if (member != null) {
                return member.getKeyValues();
            }
            return null;
        }

        private Member getLevelMember(String dimensionName, String levelName) throws BirtException, IOException {
            int dimIndex = FactTableRowIterator.this.getDimensionIndex(dimensionName);
            return this.getLevelMember(dimIndex, levelName);
        }

        private Member getLevelMember(int dimIndex, String levelName) throws BirtException, IOException {
            int levelIndex = -1;
            if (dimIndex >= 0) {
                FactTableRowIterator.this.checkAndInitDimIterator(dimIndex);
                IDimensionResultIterator itr = FactTableRowIterator.this.allCubeDimensionResultIterators[dimIndex];
                levelIndex = itr.getLevelIndex(levelName);
                if (levelIndex >= 0) {
                    return FactTableRowIterator.this.getMember(dimIndex, levelIndex);
                }
            }
            return null;
        }
    }
}

