/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import org.eclipse.birt.data.engine.expression.ConstantExpression;
import org.mozilla.javascript.Node;

public class AggregationConstantsUtil {
    private static String NO_FILTER = "NO_FILTER";
    private static String CURRENT_GROUP = "CURRENT_GROUP";
    private static String OVERALL = "OVERALL";
    private static String TOTAL = "TOTAL";

    public static ConstantExpression getConstantExpression(Node child) {
        if (child.getFirstChild().getType() == 44 && child.getFirstChild().getString().equalsIgnoreCase(TOTAL) && child.getLastChild().getType() == 46) {
            String property = child.getLastChild().getString();
            if (CURRENT_GROUP.equalsIgnoreCase(property) || OVERALL.equalsIgnoreCase(property)) {
                return new ConstantExpression(property.toUpperCase());
            }
            if (NO_FILTER.equalsIgnoreCase(property)) {
                return new ConstantExpression();
            }
        }
        return null;
    }

    public static int getGroupLevel(String constant, int currentGroupLevel, int innerMostGroupLevel, boolean isDetailedRow) {
        int result = -1;
        if (OVERALL.equalsIgnoreCase(constant)) {
            result = 0;
        } else if (CURRENT_GROUP.equalsIgnoreCase(constant)) {
            result = currentGroupLevel == 0 && isDetailedRow ? innerMostGroupLevel : currentGroupLevel;
        }
        return result;
    }
}

