/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.cache.CacheRequest;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.SmartCache;
import org.eclipse.birt.data.engine.executor.cache.SmartRowResultSet;
import org.eclipse.birt.data.engine.executor.dscache.DataSetFromCache;
import org.eclipse.birt.data.engine.executor.dscache.DataSetToCache;
import org.eclipse.birt.data.engine.executor.transform.CachedResultSet;
import org.eclipse.birt.data.engine.executor.transform.IExpressionProcessor;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.OrderingInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupProcessorManager;
import org.eclipse.birt.data.engine.executor.transform.pass.PassManager;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class ResultSetPopulator {
    private ResultSetCache smartCache;
    private IExpressionProcessor exprProcessor = null;
    private BaseQuery query;
    private IResultClass rsMeta;
    private CachedResultSet ri;
    private GroupProcessorManager groupProcessorManager;
    private IEventHandler eventHandler;
    private boolean clearCacheResultSet = true;
    protected DataEngineSession session;

    public ResultSetPopulator(BaseQuery query, IResultClass rsMeta, CachedResultSet ri, DataEngineSession session, IEventHandler eventHandler) throws DataException {
        this.query = query;
        this.rsMeta = rsMeta;
        this.ri = ri;
        this.session = session;
        this.eventHandler = eventHandler;
        this.groupProcessorManager = new GroupProcessorManager(query, this, this.session);
        this.exprProcessor = query.getExprProcessor();
        this.exprProcessor.setQuery(this.query);
        this.exprProcessor.setResultSetPopulator(this);
    }

    public IEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public GroupProcessorManager getGroupProcessorManager() {
        return this.groupProcessorManager;
    }

    public BaseQuery getQuery() {
        return this.query;
    }

    void setQuery(BaseQuery query) {
        this.query = query;
    }

    public ResultSetCache getCache() {
        return this.smartCache;
    }

    public boolean clearCacheResultSet() {
        return this.clearCacheResultSet;
    }

    public void setClearCacheResultSet(boolean flag) {
        this.clearCacheResultSet = flag;
    }

    public void setCache(ResultSetCache cache) {
        this.smartCache = cache;
    }

    public IResultClass getResultSetMetadata() {
        return this.rsMeta;
    }

    public void setResultSetMetadata(IResultClass resultMeta) {
        this.rsMeta = resultMeta;
    }

    public CachedResultSet getResultIterator() {
        return this.ri;
    }

    public IExpressionProcessor getExpressionProcessor() {
        return this.exprProcessor;
    }

    public void populateResultSet(OdiResultSetWrapper odaResultSet) throws DataException {
        PassManager.populateResultSet(this, odaResultSet, this.session);
    }

    public DataSetFromCache cacheDataSet(DataSetToCache dstc) throws DataException {
        PassManager.populateDataSetResultSet(this, new OdiResultSetWrapper(dstc));
        CachedResultSet itr = this.getResultIterator();
        dstc.saveDataSetResult(itr);
        return new DataSetFromCache(this.session);
    }

    public void reSetSmartCacheUsingOrderingInfo(OrderingInfo odInfo) throws DataException {
        this.reSetCache(odInfo);
        this.groupProcessorManager.getGroupCalculationUtil().getGroupInformationUtil().doGrouping();
        this.getCache().next();
    }

    public void reSetCache(OrderingInfo odInfo) throws DataException {
        this.getCache().reset();
        this.getCache().next();
        this.setCache(new SmartCache(new CacheRequest(this.query.getMaxRows(), this.query.getFetchEvents(), null, this.getEventHandler()), new SmartRowResultSet(this.getCache(), this.rsMeta, odInfo), this.rsMeta, this.session));
        this.groupProcessorManager.getGroupCalculationUtil().setResultSetCache(this.getCache());
    }

    void first(int groupLevel) throws DataException {
        this.groupProcessorManager.getGroupCalculationUtil().getGroupInformationUtil().first(groupLevel);
    }

    void last(int groupLevel) throws DataException {
        this.groupProcessorManager.getGroupCalculationUtil().getGroupInformationUtil().last(groupLevel);
    }

    int getEndingGroupLevel() throws DataException {
        return this.groupProcessorManager.getGroupCalculationUtil().getGroupInformationUtil().getEndingGroupLevel();
    }

    int getStartingGroupLevel() throws DataException {
        return this.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().getStartingGroupLevel();
    }

    int getCurrentGroupIndex(int groupLevel) throws DataException {
        return this.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().getCurrentGroupIndex(groupLevel);
    }

    public int[] getGroupStartAndEndIndex(int groupLevel) throws DataException {
        return this.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().getGroupStartAndEndIndex(groupLevel);
    }

    public DataEngineSession getSession() {
        return this.session;
    }
}

