/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api.querydefn;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefnDelegator;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;

public class NoRecalculateIVQuery
extends QueryDefnDelegator {
    private IBaseQueryDefinition sourceQuery;
    private HashMap<String, IBinding> bindingsMap = new HashMap();
    private List<IFilterDefinition> filters;
    private List<ISortDefinition> sortings;
    private List groups;
    private String name;

    public NoRecalculateIVQuery(IQueryDefinition queryDefn, IBaseQueryDefinition sourceQuery, List<ISortDefinition> sorts, List<IFilterDefinition> filters, List groups, String queryResultId) throws DataException {
        super(queryDefn);
        this.queryResultsId = queryResultId;
        this.dataSetName = queryDefn.getDataSetName();
        this.sourceQuery = new QueryDefnDelegator(sourceQuery, this.queryResultsId, this.dataSetName);
        this.filters = filters;
        this.sortings = sorts;
        this.groups = groups;
        this.initBindings();
    }

    private void initBindings() throws DataException {
        for (Map.Entry e : this.baseQuery.getBindings().entrySet()) {
            IBinding b = (IBinding)e.getValue();
            Binding n = new Binding(b.getBindingName());
            n.setDataType(b.getDataType());
            n.setDisplayName(b.getDisplayName());
            n.setExportable(b.exportable());
            n.setFilter(b.getFilter());
            n.setTimeFunction(b.getTimeFunction());
            n.setExpression(new ScriptExpression("dataSetRow[\"" + b.getBindingName() + "\"]"));
            this.bindingsMap.put(n.getBindingName(), n);
        }
    }

    @Override
    public List getGroups() {
        return this.groups;
    }

    @Override
    public void addBinding(IBinding binding) throws DataException {
        this.bindingsMap.put(binding.getBindingName(), binding);
    }

    @Override
    public Map getBindings() {
        return this.bindingsMap;
    }

    @Override
    public List getFilters() {
        return this.filters;
    }

    @Override
    public List getSorts() {
        return this.sortings;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IBaseQueryDefinition getSourceQuery() {
        return this.sourceQuery;
    }

    @Override
    public IQueryDefinition getBaseQuery() {
        return (IQueryDefinition)this.baseQuery;
    }

    @Override
    public void setSourceQuery(IBaseQueryDefinition object) {
        this.sourceQuery = object;
    }
}

