/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;

public class SqlBlobUtil {
    public static Blob newBlob(InputStream inputStream) {
        return new BlobHelper(inputStream);
    }

    private static class BlobHelper
    implements Blob {
        private InputStream inputStream;
        private boolean isInit;
        private int blobLength = -1;
        private byte[] blobContent = null;

        BlobHelper(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        private void init() throws SQLException {
            if (this.isInit) {
                return;
            }
            ArrayList<Integer> byteList = new ArrayList<Integer>();
            try {
                int b;
                while ((b = this.inputStream.read()) != -1) {
                    byteList.add(b);
                }
                this.inputStream.close();
            }
            catch (IOException e1) {
                throw new SQLException("can not read from blob data");
            }
            this.blobLength = byteList.size();
            this.blobContent = new byte[this.blobLength];
            int i = 0;
            while (i < this.blobLength) {
                this.blobContent[i] = (byte)((Integer)byteList.get(i)).intValue();
                ++i;
            }
            byteList = null;
            this.isInit = true;
        }

        @Override
        public long length() throws SQLException {
            this.init();
            return this.blobLength;
        }

        @Override
        public void truncate(long len) throws SQLException {
            throw new SQLException("Unsupported in this database");
        }

        @Override
        public byte[] getBytes(long pos, int length) throws SQLException {
            this.init();
            int destPos = (int)(pos - 1L + (long)length);
            if (destPos > this.blobLength) {
                throw new SQLException("pos or length is not valid");
            }
            int startPos = (int)(pos - 1L);
            byte[] content = new byte[length];
            System.arraycopy(this.blobContent, startPos, content, startPos, length);
            return content;
        }

        @Override
        public int setBytes(long pos, byte[] bytes) throws SQLException {
            throw new SQLException("Unsupported in this database");
        }

        @Override
        public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
            throw new SQLException("Unsupported in this database");
        }

        @Override
        public long position(byte[] pattern, long start) throws SQLException {
            throw new SQLException("Unsupported in this database");
        }

        @Override
        public InputStream getBinaryStream() throws SQLException {
            this.init();
            return new ByteArrayInputStream(this.blobContent);
        }

        @Override
        public OutputStream setBinaryStream(long pos) throws SQLException {
            throw new SQLException("Unsupported in this database");
        }

        @Override
        public long position(Blob pattern, long start) throws SQLException {
            throw new SQLException("Unsupported in this database");
        }

        @Override
        public void free() throws SQLException {
            throw new SQLException("Unsupported in this database");
        }

        @Override
        public InputStream getBinaryStream(long pos, long length) throws SQLException {
            throw new SQLException("Unsupported in this database");
        }
    }
}

