/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.util.ULocale;
import java.util.Stack;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.engine.value.birt.BIRTValueConstants;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.emitter.HTMLWriter;
import org.eclipse.birt.report.engine.emitter.html.AttributeBuilder;
import org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitter;
import org.eclipse.birt.report.engine.emitter.html.util.HTMLEmitterUtil;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.w3c.dom.css.CSSValue;

public abstract class HTMLEmitter {
    protected HTMLReportEmitter reportEmitter;
    protected HTMLWriter writer;
    protected boolean fixedReport = false;
    protected boolean enableInlineStyle = false;
    protected int browserVersion = -1;
    private static String BORDER_STYLE_NONE = "none";
    protected Stack<Integer> containerDisplayStack = new Stack();
    private static final DecimalFormat FORMATTER = new DecimalFormat("#.###", new DecimalFormatSymbols(ULocale.ENGLISH));

    public HTMLEmitter(HTMLReportEmitter reportEmitter, HTMLWriter writer, boolean fixedReport, boolean enableInlineStyle, int browserVersion) {
        this.reportEmitter = reportEmitter;
        this.writer = writer;
        this.fixedReport = fixedReport;
        this.enableInlineStyle = enableInlineStyle;
        this.browserVersion = browserVersion;
    }

    public abstract void buildDefaultStyle(StringBuffer var1, IStyle var2);

    public abstract void buildStyle(StringBuffer var1, IStyle var2);

    public abstract void buildPageBandStyle(StringBuffer var1, IStyle var2);

    public abstract void buildTableStyle(ITableContent var1, StringBuffer var2);

    public abstract void buildColumnStyle(IColumn var1, StringBuffer var2);

    public abstract void handleColumnAlign(IColumn var1);

    public abstract void buildRowStyle(IRowContent var1, StringBuffer var2);

    public abstract void handleRowAlign(IRowContent var1);

    public abstract void buildCellStyle(ICellContent var1, StringBuffer var2, boolean var3, boolean var4);

    public void handleCellAlign(ICellContent cell) {
        IStyle style = cell.getStyle();
        CSSValue hAlign = style.getProperty(37);
        if (hAlign != null) {
            this.writer.attribute("align", hAlign.getCssText());
        }
    }

    public abstract void handleCellVAlign(ICellContent var1);

    public abstract void buildContainerStyle(IContainerContent var1, StringBuffer var2);

    public abstract void handleContainerAlign(IContainerContent var1);

    public abstract void buildTextStyle(ITextContent var1, StringBuffer var2, int var3);

    public abstract void buildForeignStyle(IForeignContent var1, StringBuffer var2, int var3);

    public abstract void buildImageStyle(IImageContent var1, StringBuffer var2, int var3);

    public void buildPageStyle(IPageContent page, StringBuffer styleBuffer, boolean needOutputBackgroundSize) {
        IStyle style = page.getStyle();
        if (!needOutputBackgroundSize) {
            DimensionType[] pageSize = new DimensionType[]{page.getPageHeight(), page.getPageWidth()};
            AttributeBuilder.buildBackground(styleBuffer, style, this.reportEmitter, pageSize);
        } else {
            AttributeBuilder.buildBackgroundColor(styleBuffer, style, this.reportEmitter);
        }
        AttributeBuilder.buildBorders(styleBuffer, style);
    }

    public void buildSize(StringBuffer content, String name, DimensionType value) {
        this.buildSize(content, name, value, null);
    }

    public void buildSize(StringBuffer content, String name, String value) {
        this.buildSize(content, name, null, value);
    }

    private void buildSize(StringBuffer content, String name, DimensionType value, String directValue) {
        if (value != null || directValue != null) {
            boolean percentageUnit = false;
            String size = "auto";
            if (value != null) {
                percentageUnit = value.getUnits().equals("%");
                size = this.formatSize(value);
            } else if (directValue != null) {
                percentageUnit = directValue.equals("%");
                size = directValue;
            }
            if ("min-height".equals(name)) {
                if (this.fixedReport || percentageUnit) {
                    content.append(" height: ");
                    content.append(size);
                    content.append(';');
                } else {
                    content.append(" height: auto !important; height: ");
                    content.append(size);
                    content.append("; min-height: ");
                    content.append(size);
                    content.append(';');
                }
            } else if ("min-width".equals(name)) {
                if (this.fixedReport || percentageUnit) {
                    content.append(" width: ");
                    content.append(size);
                    content.append(';');
                } else {
                    content.append(" width: auto !important; width: ");
                    content.append(size);
                    content.append("; min-width: ");
                    content.append(size);
                    content.append(';');
                }
            } else {
                content.append(' ');
                content.append(name);
                content.append(": ");
                content.append(size);
                content.append(';');
            }
        }
    }

    private String formatSize(DimensionType value) {
        assert (value != null);
        if (value.getValueType() == 1) {
            return FORMATTER.format(value.getMeasure()) + value.getUnits();
        }
        return value.toString();
    }

    protected IStyle getElementStyle(IContent content) {
        IStyle style = null;
        style = this.enableInlineStyle ? content.getStyle() : content.getInlineStyle();
        if (style == null || style.isEmpty()) {
            return null;
        }
        style = this.inheritBorderStyle(style, content.getComputedStyle());
        return style;
    }

    private IStyle inheritBorderStyle(IStyle style, IStyle computedStyle) {
        if (computedStyle.getBorderTopStyle() != null && !computedStyle.getBorderTopStyle().equals(BORDER_STYLE_NONE)) {
            if (style.getBorderTopColor() == null && computedStyle.getBorderTopColor() != null) {
                style.setBorderTopColor(computedStyle.getBorderTopColor());
            }
            if (style.getBorderTopWidth() == null && computedStyle.getBorderTopWidth() != null) {
                style.setBorderTopWidth(computedStyle.getBorderTopWidth());
            }
            if (style.getBorderTopStyle() == null && computedStyle.getBorderTopStyle() != null) {
                style.setBorderTopStyle(computedStyle.getBorderTopStyle());
            }
        }
        if (computedStyle.getBorderBottomStyle() != null && !computedStyle.getBorderBottomStyle().equals(BORDER_STYLE_NONE)) {
            if (style.getBorderBottomColor() == null && computedStyle.getBorderBottomColor() != null) {
                style.setBorderBottomColor(computedStyle.getBorderBottomColor());
            }
            if (style.getBorderBottomWidth() == null && computedStyle.getBorderBottomWidth() != null) {
                style.setBorderBottomWidth(computedStyle.getBorderBottomWidth());
            }
            if (style.getBorderBottomStyle() == null && computedStyle.getBorderBottomStyle() != null) {
                style.setBorderBottomStyle(computedStyle.getBorderBottomStyle());
            }
        }
        if (computedStyle.getBorderLeftStyle() != null && !computedStyle.getBorderLeftStyle().equals(BORDER_STYLE_NONE)) {
            if (style.getBorderLeftColor() == null && computedStyle.getBorderLeftColor() != null) {
                style.setBorderLeftColor(computedStyle.getBorderLeftColor());
            }
            if (style.getBorderLeftWidth() == null && computedStyle.getBorderLeftWidth() != null) {
                style.setBorderLeftWidth(computedStyle.getBorderLeftWidth());
            }
            if (style.getBorderLeftStyle() == null && computedStyle.getBorderLeftStyle() != null) {
                style.setBorderLeftStyle(computedStyle.getBorderLeftStyle());
            }
        }
        if (computedStyle.getBorderRightStyle() != null && !computedStyle.getBorderRightStyle().equals(BORDER_STYLE_NONE)) {
            if (style.getBorderRightColor() == null && computedStyle.getBorderRightColor() != null) {
                style.setBorderRightColor(computedStyle.getBorderRightColor());
            }
            if (style.getBorderRightWidth() == null && computedStyle.getBorderRightWidth() != null) {
                style.setBorderRightWidth(computedStyle.getBorderRightWidth());
            }
            if (style.getBorderRightStyle() == null && computedStyle.getBorderRightStyle() != null) {
                style.setBorderRightStyle(computedStyle.getBorderRightStyle());
            }
        }
        return style;
    }

    public CSSValue getElementDisplay(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style) {
        CSSValue display = null;
        if (style != null) {
            display = style.getProperty(63);
        }
        if (CSSValueConstants.NONE_VALUE == display) {
            return CSSValueConstants.NONE_VALUE;
        }
        if (x != null || y != null) {
            return CSSValueConstants.BLOCK_VALUE;
        }
        if (CSSValueConstants.INLINE_VALUE == display) {
            if (width != null || height != null) {
                return CSSValueConstants.INLINE_BLOCK_VALUE;
            }
            if ("rtl".equals(style.getDirection())) {
                return CSSValueConstants.INLINE_BLOCK_VALUE;
            }
            return CSSValueConstants.INLINE_VALUE;
        }
        return CSSValueConstants.BLOCK_VALUE;
    }

    public int getElementType(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style) {
        int type = 0;
        String display = null;
        if (style != null) {
            display = style.getDisplay();
        }
        if ("none".equalsIgnoreCase(display)) {
            type |= 8;
        }
        if (x != null || y != null) {
            return type | 1;
        }
        if ("inline".equalsIgnoreCase(display)) {
            type |= 2;
            if (width != null || height != null) {
                type |= 4;
            } else if ("rtl".equals(style.getDirection())) {
                type |= 4;
            }
            return type;
        }
        return type | 1;
    }

    public int getTextElementType(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style) {
        int type = 0;
        String display = null;
        if (style != null) {
            display = style.getDisplay();
        }
        if ("none".equalsIgnoreCase(display)) {
            type |= 8;
        }
        if (x != null || y != null) {
            return type | 1;
        }
        if ("inline".equalsIgnoreCase(display)) {
            type |= 2;
            if (width != null) {
                type |= 4;
            } else if ("rtl".equals(style.getDirection())) {
                type |= 4;
            }
            return type;
        }
        return type | 1;
    }

    protected void addDefaultTableStyles(StringBuffer styleBuffer) {
        styleBuffer.append("border-collapse: collapse; empty-cells: show;");
    }

    protected boolean handleShrink(int type, IStyle style, DimensionType height, DimensionType width, StringBuffer styleBuffer) {
        boolean canShrink;
        boolean bl = canShrink = style != null && "true".equalsIgnoreCase(style.getCanShrink());
        if ((type & 1) > 0) {
            this.buildSize(styleBuffer, "width", width);
            if (!canShrink) {
                this.buildSize(styleBuffer, "min-height", height);
            }
        } else if ((type & 2) > 0) {
            this.buildSize(styleBuffer, "height", height);
            if (!canShrink) {
                this.buildSize(styleBuffer, "min-width", width);
            }
        } else assert (false);
        HTMLEmitterUtil.buildOverflowStyle(styleBuffer, style, false);
        return canShrink;
    }

    protected boolean handleTextShrink(int type, IStyle style, DimensionType height, DimensionType width, StringBuffer styleBuffer) {
        boolean canShrink = style != null && "true".equalsIgnoreCase(style.getCanShrink());
        boolean outputHidden = false;
        if ((type & 1) > 0) {
            if (width != null) {
                this.buildSize(styleBuffer, "width", width);
                outputHidden = true;
            }
            if (!canShrink) {
                this.buildSize(styleBuffer, "min-height", height);
            }
        } else if ((type & 2) > 0) {
            if ((type & 4) > 0) {
                this.buildSize(styleBuffer, "height", height);
            }
            if (!canShrink && width != null) {
                this.buildSize(styleBuffer, "width", width);
                outputHidden = true;
            }
        } else assert (false);
        HTMLEmitterUtil.buildOverflowStyle(styleBuffer, style, outputHidden);
        return canShrink;
    }

    public void openContainerTag(IContainerContent container) {
        DimensionType x = container.getX();
        DimensionType y = container.getY();
        DimensionType width = container.getWidth();
        DimensionType height = container.getHeight();
        int display = this.getElementType(x, y, width, height, container.getStyle());
        this.containerDisplayStack.push(display);
        if (!(this.reportEmitter.browserSupportsInlineBlock || (display & 2) <= 0 && (display & 4) <= 0)) {
            this.openInlineBoxTag();
        }
        this.writer.openTag("div");
    }

    public void closeContainerTag() {
        this.writer.closeTag("div");
        int display = this.containerDisplayStack.pop();
        if (!(this.reportEmitter.browserSupportsInlineBlock || (display & 2) <= 0 && (display & 4) <= 0)) {
            this.closeInlineBoxTag();
        }
    }

    protected void openInlineBoxTag() {
        this.writer.openTag("div");
        this.writer.attribute("style", " display:-moz-inline-box; display:inline-block; *+display:inline;");
        this.writer.openTag("table");
        this.writer.attribute("style", " display:table !important; display:inline;");
        this.writer.openTag("tr");
        this.writer.openTag("td");
    }

    protected void closeInlineBoxTag() {
        this.writer.closeTag("td");
        this.writer.closeTag("tr");
        this.writer.closeTag("table");
        this.writer.closeTag("div");
    }

    protected void setDisplayProperty(int display, int mask, StringBuffer styleBuffer) {
        int flag = display & mask;
        if ((display & 8) > 0) {
            styleBuffer.append("display: none;");
        } else if (flag > 0) {
            if ((flag & 1) > 0) {
                styleBuffer.append("display: block;");
            } else if ((flag & 4) > 0) {
                styleBuffer.append("display:inline-block; zoom:1; *+display:inline;");
            } else if ((flag & 2) > 0) {
                styleBuffer.append("display: inline;");
            }
        }
    }

    public void handleTextVerticalAlignBegin(IContent element) {
        IStyle style = element.getStyle();
        CSSValue vAlign = style.getProperty(43);
        CSSValue canShrink = style.getProperty(34);
        DimensionType height = element.getHeight();
        if (vAlign != null && vAlign != CSSValueConstants.BASELINE_VALUE && height != null && canShrink != BIRTValueConstants.TRUE_VALUE) {
            this.writer.openTag("table");
            StringBuilder nestingTableStyleBuffer = new StringBuilder();
            nestingTableStyleBuffer.append(" width:100%; height:");
            nestingTableStyleBuffer.append(height.toString());
            this.writer.attribute("style", nestingTableStyleBuffer.toString());
            this.writer.openTag("tr");
            this.writer.openTag("td");
            StringBuilder textStyleBuffer = new StringBuilder();
            textStyleBuffer.append(" vertical-align:");
            textStyleBuffer.append(vAlign.getCssText());
            textStyleBuffer.append(";");
            this.writer.attribute("style", textStyleBuffer.toString());
        }
    }

    public void handleVerticalAlignEnd(IContent element) {
        IStyle style = element.getStyle();
        CSSValue vAlign = style.getProperty(43);
        CSSValue canShrink = style.getProperty(34);
        DimensionType height = element.getHeight();
        if (vAlign != null && vAlign != CSSValueConstants.BASELINE_VALUE && height != null && canShrink != BIRTValueConstants.TRUE_VALUE) {
            this.writer.closeTag("td");
            this.writer.closeTag("tr");
            this.writer.closeTag("table");
        }
    }
}

