/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service.template;

import java.util.ArrayList;
import java.util.List;
import me.prettyprint.cassandra.service.template.AbstractColumnFamilyTemplate;
import me.prettyprint.hector.api.ColumnFactory;
import me.prettyprint.hector.api.mutation.Mutator;

public abstract class AbstractTemplateUpdater<K, N> {
    protected static final int DEF_TTL = 0;
    protected List<K> keys;
    protected int keyPos = 0;
    protected ColumnFactory columnFactory;
    protected AbstractColumnFamilyTemplate<K, N> template;
    protected Mutator<K> mutator;
    protected long clock;
    protected int globalTtl;

    public AbstractTemplateUpdater(AbstractColumnFamilyTemplate<K, N> template, ColumnFactory columnFactory, Mutator<K> mutator) {
        this.template = template;
        this.columnFactory = columnFactory;
        this.mutator = mutator;
        this.clock = template.getClock();
        this.globalTtl = 0;
    }

    public AbstractTemplateUpdater<K, N> addKey(K key) {
        if (this.keys == null) {
            this.keys = new ArrayList<K>();
        } else {
            ++this.keyPos;
        }
        this.keys.add(key);
        return this;
    }

    public K getCurrentKey() {
        return this.keys.get(this.keyPos);
    }

    public void update() {
    }

    public Mutator<K> getCurrentMutator() {
        return this.mutator;
    }

    public void setClock(long clock) {
        this.clock = clock;
    }

    public void setTtl(int ttl) {
        this.globalTtl = ttl;
    }
}

