/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import me.prettyprint.cassandra.connection.BackgroundCassandraHostService;
import me.prettyprint.cassandra.connection.HConnectionManager;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.ThriftCluster;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.factory.HFactory;
import org.apache.cassandra.thrift.EndpointDetails;
import org.apache.cassandra.thrift.TokenRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeAutoDiscoverService
extends BackgroundCassandraHostService {
    private static final Logger log = LoggerFactory.getLogger(NodeAutoDiscoverService.class);
    public static final int DEF_AUTO_DISCOVERY_DELAY = 30;
    private DataCenterValidator dataCenterValidator;

    public NodeAutoDiscoverService(HConnectionManager connectionManager, CassandraHostConfigurator cassandraHostConfigurator) {
        super(connectionManager, cassandraHostConfigurator);
        this.retryDelayInSeconds = cassandraHostConfigurator.getAutoDiscoveryDelayInSeconds();
        this.dataCenterValidator = new DataCenterValidator(cassandraHostConfigurator.getAutoDiscoveryDataCenters());
        this.sf = this.executor.scheduleWithFixedDelay(new QueryRing(), this.retryDelayInSeconds, this.retryDelayInSeconds, TimeUnit.SECONDS);
    }

    @Override
    void shutdown() {
        log.error("Auto Discovery retry shutdown hook called");
        if (this.sf != null) {
            this.sf.cancel(true);
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        log.error("AutoDiscovery retry shutdown complete");
    }

    @Override
    public void applyRetryDelay() {
    }

    public void doAddNodes() {
        Set<CassandraHost> foundHosts;
        if (log.isDebugEnabled()) {
            log.debug("Auto discovery service running...");
        }
        if ((foundHosts = this.discoverNodes()) != null && foundHosts.size() > 0) {
            log.info("Found {} new host(s) in Ring", (Object)foundHosts.size());
            for (CassandraHost cassandraHost : foundHosts) {
                log.info("Addding found host {} to pool", (Object)cassandraHost);
                this.cassandraHostConfigurator.applyConfig(cassandraHost);
                this.connectionManager.addCassandraHost(cassandraHost);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Auto discovery service run complete.");
        }
    }

    public Set<CassandraHost> discoverNodes() {
        Set<CassandraHost> existingHosts = this.connectionManager.getHosts();
        HashSet<CassandraHost> foundHosts = new HashSet<CassandraHost>();
        if (log.isDebugEnabled()) {
            log.debug("using existing hosts {}", existingHosts);
        }
        try {
            String clusterName = this.connectionManager.getClusterName();
            ThriftCluster cluster = (ThriftCluster)HFactory.getCluster(clusterName);
            for (KeyspaceDefinition keyspaceDefinition : cluster.describeKeyspaces()) {
                if (keyspaceDefinition.getName().equals("system")) continue;
                List<TokenRange> tokenRanges = cluster.describeRing(keyspaceDefinition.getName());
                for (TokenRange tokenRange : tokenRanges) {
                    for (EndpointDetails endPointDetail : tokenRange.getEndpoint_details()) {
                        CassandraHost foundHost;
                        if (!this.dataCenterValidator.validate(endPointDetail.getDatacenter()) || existingHosts.contains(foundHost = new CassandraHost(endPointDetail.getHost(), this.cassandraHostConfigurator.getPort()))) continue;
                        log.info("Found a node we don't know about {} for TokenRange {}", (Object)foundHost, (Object)tokenRange);
                        foundHosts.add(foundHost);
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("Discovery Service failed attempt to connect CassandraHost", (Throwable)e);
        }
        return foundHosts;
    }

    class DataCenterValidator {
        Set<String> dataCenters;

        public DataCenterValidator(List<String> dataCenters) {
            if (dataCenters != null) {
                this.dataCenters = new HashSet<String>(dataCenters);
            }
        }

        public boolean validate(String dcName) {
            if (this.dataCenters == null || dcName == null) {
                return true;
            }
            return this.dataCenters.contains(dcName);
        }
    }

    class QueryRing
    implements Runnable {
        QueryRing() {
        }

        @Override
        public void run() {
            NodeAutoDiscoverService.this.doAddNodes();
        }
    }
}

