/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.ui.frameworks.errordisplay;

import org.eclipse.birt.core.ui.frameworks.taskwizard.composites.MessageComposite;
import org.eclipse.birt.core.ui.i18n.Messages;
import org.eclipse.birt.core.ui.utils.UIHelper;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ErrorDialog
implements SelectionListener {
    public static final String OPTION_ACCEPT = "ACCEPT";
    public static final String OPTION_CANCEL = "CANCEL";
    public static final int MAX_TRACE_DEPTH = 2;
    public static final int DEFAULT_WIDTH = 450;
    public static final int DEFAULT_HEIGHT = 0;
    public static final int MAX_HEIGHT = 200;
    private transient Display display = Display.getDefault();
    private transient Shell shell = null;
    private transient Label lblImage = null;
    private transient Composite cmpContainer = null;
    private transient Composite cmpDetails = null;
    private transient StackLayout slDetails = null;
    private transient Group grpDetails = null;
    private transient Text txtDetails = null;
    private transient Composite cmpDummy = null;
    private transient MessageComposite mcSheetHeading = null;
    private transient Button btnOK = null;
    private transient Button btnDetails = null;
    private transient Text txtProblems = null;
    private transient Button btnCancel = null;
    private transient Group grpProblems = null;
    private transient String sMessage = null;
    private transient String sSelection = "CANCEL";
    private transient boolean bError = true;
    private transient String sErrors = null;
    private transient String sFixes = null;
    private transient String sExceptionMessage = null;
    private transient String sTrace = null;
    private transient Shell shellParent = null;

    private void init(String sTitle) {
        this.display = Display.getDefault();
        this.shell = this.shellParent == null ? new Shell(this.display, 67696) : new Shell(this.shellParent, 67696);
        this.shell.setText(sTitle);
        this.shell.setLayout((Layout)new GridLayout());
        this.placeComponents();
        UIHelper.centerOnScreen(this.shell);
        this.shell.setDefaultButton(this.btnOK);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public ErrorDialog(Shell shellParent, String sTitle, String sMessage, String[] sErrors, String[] sFixes) {
        this.shellParent = shellParent;
        this.sMessage = sMessage;
        this.sErrors = this.getOrganizedErrors(sErrors);
        this.sFixes = this.getOrganizedFixes(sFixes);
        this.bError = true;
        this.init(sTitle);
    }

    public ErrorDialog(Shell shellParent, String sTitle, String sMessage, Throwable t) {
        this.shellParent = shellParent;
        this.sMessage = sMessage;
        this.sExceptionMessage = t.getLocalizedMessage();
        if (this.sExceptionMessage == null) {
            this.sExceptionMessage = t.toString();
        }
        this.sTrace = this.getOrganizedTrace(t);
        this.bError = false;
        this.init(sTitle);
    }

    private void placeComponents() {
        this.cmpContainer = new Composite((Composite)this.shell, 0);
        GridLayout glDialog = new GridLayout(3, false);
        glDialog.marginWidth = 6;
        glDialog.marginHeight = 6;
        glDialog.horizontalSpacing = 5;
        glDialog.verticalSpacing = 2;
        this.cmpContainer.setLayoutData((Object)new GridData(1808));
        this.cmpContainer.setLayout((Layout)glDialog);
        this.mcSheetHeading = new MessageComposite(this.cmpContainer, "", this.sMessage, "", true);
        GridData gdMSGHeading = new GridData(768);
        gdMSGHeading.heightHint = 25;
        gdMSGHeading.horizontalSpan = 3;
        this.mcSheetHeading.setLayoutData(gdMSGHeading);
        this.mcSheetHeading.setBackground(this.display.getSystemColor(1));
        this.lblImage = new Label(this.cmpContainer, 0);
        this.lblImage.setImage(this.display.getSystemImage(1));
        this.grpProblems = new Group(this.cmpContainer, 0);
        GridData gdGrpProblems = new GridData(768);
        gdGrpProblems.horizontalSpan = 2;
        gdGrpProblems.heightHint = 60;
        this.grpProblems.setLayoutData((Object)gdGrpProblems);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        this.grpProblems.setLayout((Layout)layout);
        this.txtProblems = new Text((Composite)this.grpProblems, 576);
        this.txtProblems.setEditable(false);
        this.txtProblems.setLayoutData((Object)new GridData(1808));
        new Label(this.cmpContainer, 0);
        this.btnDetails = new Button(this.cmpContainer, 2);
        GridData gdBtnDetails = new GridData();
        gdBtnDetails.horizontalSpan = 2;
        this.btnDetails.setLayoutData((Object)gdBtnDetails);
        this.btnDetails.addSelectionListener((SelectionListener)this);
        new Label(this.cmpContainer, 0);
        this.slDetails = new StackLayout();
        this.cmpDetails = new Composite(this.cmpContainer, 0);
        GridData gdCmpDetails = new GridData(1808);
        gdCmpDetails.horizontalSpan = 2;
        gdCmpDetails.heightHint = 0;
        this.cmpDetails.setLayoutData((Object)gdCmpDetails);
        this.cmpDetails.setLayout((Layout)this.slDetails);
        this.cmpDummy = new Composite(this.cmpDetails, 0);
        this.grpDetails = new Group(this.cmpDetails, 0);
        FillLayout flSolutions = new FillLayout();
        flSolutions.marginWidth = 5;
        flSolutions.marginHeight = 5;
        this.grpDetails.setLayout((Layout)flSolutions);
        this.txtDetails = new Text((Composite)this.grpDetails, 2624);
        this.txtDetails.setEditable(false);
        GridLayout glButtons = new GridLayout();
        glButtons.numColumns = 2;
        glButtons.horizontalSpacing = 5;
        glButtons.marginHeight = 5;
        glButtons.marginWidth = 5;
        Composite cmpButtons = new Composite(this.cmpContainer, 0);
        GridData gdCmpButtons = new GridData(768);
        gdCmpButtons.horizontalSpan = 3;
        cmpButtons.setLayoutData((Object)gdCmpButtons);
        cmpButtons.setLayout((Layout)glButtons);
        this.btnOK = new Button(cmpButtons, 0);
        GridData gdBtnOK = null;
        gdBtnOK = this.bError ? new GridData(640) : new GridData(576);
        this.btnOK.setLayoutData((Object)gdBtnOK);
        this.btnOK.addSelectionListener((SelectionListener)this);
        if (this.bError) {
            this.btnCancel = new Button(cmpButtons, 0);
            GridData gdBtnCancel = new GridData(544);
            this.btnCancel.setLayoutData((Object)gdBtnCancel);
            this.btnCancel.addSelectionListener((SelectionListener)this);
        }
        if (this.bError) {
            this.grpProblems.setText(Messages.getString("ErrorDialog.text.ErrorList"));
            this.txtProblems.setText(this.sErrors);
            this.btnDetails.setText(Messages.getString("ErrorDialog.text.ShowDetails"));
            this.grpDetails.setText(Messages.getString("ErrorDialog.text.SuggestedFixes"));
            this.btnOK.setText(Messages.getString("ErrorDialog.text.FixIt"));
            this.btnCancel.setText(Messages.getString("ErrorDialog.text.ProceedWithoutFixing"));
            if (this.sFixes == null || this.sFixes.length() == 0) {
                this.btnDetails.setEnabled(false);
            } else {
                this.btnDetails.setEnabled(true);
                this.txtDetails.setText(this.sFixes);
            }
        } else {
            this.txtProblems.setText(this.sExceptionMessage);
            this.btnDetails.setText(Messages.getString("ErrorDialog.text.ShowTrace"));
            this.grpDetails.setText(Messages.getString("ErrorDialog.text.StackTrace"));
            this.btnOK.setText(Messages.getString("ErrorDialog.text.Ok"));
            if (this.sTrace == null || this.sTrace.length() == 0) {
                this.btnDetails.setEnabled(false);
            } else {
                this.btnDetails.setEnabled(true);
                this.txtDetails.setText(this.sTrace);
            }
        }
        this.slDetails.topControl = this.cmpDummy;
        this.shell.pack();
        this.shell.layout();
    }

    public String getOption() {
        return this.sSelection;
    }

    private String getOrganizedErrors(String[] errors) {
        if (errors.length == 1) {
            return errors[0];
        }
        StringBuilder sbErrors = new StringBuilder("");
        int i = 0;
        while (i < errors.length) {
            if (i > 0) {
                sbErrors.append("\n");
            }
            sbErrors.append(String.valueOf(i + 1) + "] ");
            sbErrors.append(errors[i]);
            ++i;
        }
        return sbErrors.toString();
    }

    private String getOrganizedFixes(String[] fixes) {
        StringBuilder sbFixes = new StringBuilder("");
        int i = 0;
        while (i < fixes.length) {
            if (i > 0) {
                sbFixes.append("\n");
            }
            sbFixes.append(fixes[i]);
            ++i;
        }
        return sbFixes.toString();
    }

    private String getOrganizedTrace(Throwable t) {
        StringBuilder sbTrace = new StringBuilder(t.getClass().getName());
        sbTrace.append(" at:\n");
        int d = 0;
        while (d < 2) {
            if (d > 0) {
                while (t.getCause() != null) {
                    t = t.getCause();
                }
                sbTrace.append(String.valueOf(Messages.getString("ErrorDialog.text.CausedBy")) + t.getLocalizedMessage() + "\n");
            }
            StackTraceElement[] se = t.getStackTrace();
            int i = 0;
            while (i < se.length) {
                if (i > 0) {
                    sbTrace.append("\n");
                }
                sbTrace.append(se[i].toString());
                ++i;
            }
            ++d;
        }
        return sbTrace.toString();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.btnOK)) {
            this.sSelection = OPTION_ACCEPT;
            this.shell.dispose();
        } else if (e.getSource().equals(this.btnCancel)) {
            this.sSelection = OPTION_CANCEL;
            this.shell.dispose();
        } else if (e.getSource().equals(this.btnDetails)) {
            this.toggleDetails(this.btnDetails.getSelection());
        }
    }

    private void toggleDetails(boolean bVisible) {
        if (bVisible) {
            this.slDetails.topControl = this.grpDetails;
            ((GridData)this.cmpDetails.getLayoutData()).heightHint = 200;
        } else {
            this.slDetails.topControl = this.cmpDummy;
            ((GridData)this.cmpDetails.getLayoutData()).heightHint = 0;
        }
        this.shell.pack();
        this.shell.layout();
    }
}

