/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.models;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.data.oda.pojo.ui.i18n.Messages;

public enum OdaType {
    String("String", Messages.getString("DataSet.DataType.String")),
    Integer("Integer", Messages.getString("DataSet.DataType.Integer")),
    Double("Double", Messages.getString("DataSet.DataType.Double")),
    Decimal("Decimal", Messages.getString("DataSet.DataType.Decimal")),
    Date("Date", Messages.getString("DataSet.DataType.Date")),
    Time("Time", Messages.getString("DataSet.DataType.Time")),
    Timestamp("Timestamp", Messages.getString("DataSet.DataType.Timestamp")),
    Boolean("Boolean", Messages.getString("DataSet.DataType.Boolean")),
    Blob("Blob", Messages.getString("DataSet.DataType.Blob")),
    Object("Java Object", Messages.getString("DataSet.DataType.Object"));

    private String name;
    private String displayName;
    private static Map<String, OdaType> nameInstanceMap;

    static {
        nameInstanceMap = new HashMap<String, OdaType>();
        OdaType[] odaTypeArray = OdaType.values();
        int n = odaTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OdaType ot = odaTypeArray[n2];
            nameInstanceMap.put(ot.getName(), ot);
            ++n2;
        }
    }

    public String toString() {
        return this.getDisplayName();
    }

    private OdaType(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static OdaType getInstance(String name) {
        return nameInstanceMap.get(name);
    }

    public static class OdaTypeComparator
    implements Comparator<OdaType>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(OdaType o1, OdaType o2) {
            return o1.getDisplayName().compareTo(o2.getDisplayName());
        }
    }
}

