/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import com.ibm.icu.util.ULocale;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.i18n.ThreadResources;

public class DimensionValueUtil {
    public static void validateDecimalValue(String value) throws PropertyValueException {
        assert (value != null);
        char separator = new DecimalFormatSymbols(ThreadResources.getLocale().toLocale()).getDecimalSeparator();
        if (separator == '.') {
            if (!DimensionValue.dotSeparatorPattern.matcher(value).matches()) {
                throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 3);
            }
        } else if (separator == ',') {
            if (!DimensionValue.commaSeparatorPattern.matcher(value).matches()) {
                throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 3);
            }
        } else assert (false);
    }

    public static String validateUnit(String value) throws PropertyValueException {
        assert (value != null);
        int indexOfFirstLetter = DimensionValue.indexOfUnitLetter(value);
        if (indexOfFirstLetter == -1) {
            return "";
        }
        String suffix = value.substring(indexOfFirstLetter).trim();
        if (suffix.equalsIgnoreCase("in")) {
            return "in";
        }
        if (suffix.equalsIgnoreCase("cm")) {
            return "cm";
        }
        if (suffix.equalsIgnoreCase("mm")) {
            return "mm";
        }
        if (suffix.equalsIgnoreCase("pt")) {
            return "pt";
        }
        if (suffix.equalsIgnoreCase("pc")) {
            return "pc";
        }
        if (suffix.equalsIgnoreCase("em")) {
            return "em";
        }
        if (suffix.equalsIgnoreCase("ex")) {
            return "ex";
        }
        if (suffix.equalsIgnoreCase("px")) {
            return "px";
        }
        if (suffix.equalsIgnoreCase("%")) {
            return "%";
        }
        throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 3);
    }

    public static DimensionValue doParse(String value, boolean localeDependent, ULocale locale) throws PropertyValueException {
        if ((value = StringUtil.trimString(value)) == null) {
            return null;
        }
        if (locale == null) {
            locale = ThreadResources.getLocale();
        }
        String units = DimensionValueUtil.validateUnit(value);
        int indexOfFirstLetter = DimensionValue.indexOfUnitLetter(value);
        if (indexOfFirstLetter != -1 && (value = StringUtil.trimString(value.substring(0, indexOfFirstLetter))) == null) {
            return null;
        }
        double measure = 0.0;
        try {
            if (localeDependent) {
                DimensionValueUtil.validateDecimalValue(value);
                Number number = NumberFormat.getNumberInstance(locale.toLocale()).parse(value);
                measure = number.doubleValue();
            } else {
                measure = Double.parseDouble(value);
            }
        }
        catch (NumberFormatException | ParseException e) {
            throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 3);
        }
        return new DimensionValue(measure, units);
    }

    public static boolean isValidUnit(String unit) {
        return "in".equalsIgnoreCase(unit) || "cm".equalsIgnoreCase(unit) || "mm".equalsIgnoreCase(unit) || "pt".equalsIgnoreCase(unit) || "pc".equalsIgnoreCase(unit) || "em".equalsIgnoreCase(unit) || "ex".equalsIgnoreCase(unit) || "px".equalsIgnoreCase(unit) || "%".equalsIgnoreCase(unit);
    }
}

