/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser.namespace;

import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.parser.CombineIterator;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.namespace.QualifiedNameValidationServices;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.validation.type.IType;

public class QualifiedNameAstValidator
extends AstValidator {
    private static final String IS_INCOMPATIBLE_WITH = " is incompatible with ";

    public QualifiedNameAstValidator(QualifiedNameValidationServices services) {
        super(services);
    }

    @Override
    protected QualifiedNameValidationServices getServices() {
        return (QualifiedNameValidationServices)super.getServices();
    }

    public String validateOverrideReturnType(String name, Set<IType> returnTypes, List<Set<IType>> parameterTypes) {
        IQualifiedNameQueryEnvironment queryEnvironment = this.getServices().getQueryEnvironment();
        CombineIterator it = new CombineIterator(parameterTypes);
        StringBuilder builder = new StringBuilder();
        while (it.hasNext()) {
            Object types = it.next();
            IService<?> superService = queryEnvironment.getLookupEngine().superServiceLookup(name, types.toArray(new IType[types.size()]));
            if (superService == null) continue;
            Set<IType> superReturnTypes = superService.getType(queryEnvironment);
            StringBuilder incompatibleTypeBuilder = new StringBuilder();
            for (IType superReturnType : superReturnTypes) {
                for (IType returnType : returnTypes) {
                    if (superReturnType.isAssignableFrom(returnType)) continue;
                    incompatibleTypeBuilder.append("\t" + String.valueOf(superReturnType) + IS_INCOMPATIBLE_WITH + String.valueOf(returnType) + "\n");
                }
            }
            if (incompatibleTypeBuilder.length() == 0) continue;
            builder.append(superService.getLongSignature() + "\n");
            builder.append(incompatibleTypeBuilder.toString());
        }
        String res = builder.length() != 0 ? "Return type incompatible with overrided service:\n" + builder.substring(0, builder.length() - 1) : null;
        return res;
    }
}

