/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ide.runtime.impl.namespace.workspace;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.acceleo.query.ide.QueryPlugin;
import org.eclipse.acceleo.query.ide.runtime.namespace.workspace.IWorkspaceResolverProvider;
import org.eclipse.acceleo.query.runtime.impl.namespace.workspace.QueryWorkspaceQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.namespace.workspace.IQueryWorkspaceQualifiedNameResolver;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;

public class EclipseWorkspaceQualifiedNameResolver
extends QueryWorkspaceQualifiedNameResolver {
    private final IProject project;
    private final IWorkspaceResolverProvider resolverProvider;

    public EclipseWorkspaceQualifiedNameResolver(IProject project, IQualifiedNameResolver resolver, IWorkspaceResolverProvider resolverProvider) {
        super(resolver);
        this.project = project;
        this.resolverProvider = resolverProvider;
    }

    protected Set<IQueryWorkspaceQualifiedNameResolver> getDependencies() {
        LinkedHashSet<IQueryWorkspaceQualifiedNameResolver> res = new LinkedHashSet<IQueryWorkspaceQualifiedNameResolver>();
        if (this.project.isAccessible()) {
            try {
                IProject[] iProjectArray = this.project.getReferencedProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IQueryWorkspaceQualifiedNameResolver resolver;
                    IProject project = iProjectArray[n2];
                    if (project.exists() && project.isOpen() && (resolver = this.resolverProvider.getResolver(project)) != null) {
                        res.add(resolver);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                QueryPlugin.INSTANCE.log(new Status(4, "org.eclipse.acceleo.query.ide", "can't resolve project dependencies for " + this.project.getName(), (Throwable)e));
            }
        } else {
            IProject[] iProjectArray = this.project.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n3 = 0;
            while (n3 < n) {
                IQueryWorkspaceQualifiedNameResolver resolver;
                IProject workspaceProject = iProjectArray[n3];
                if (workspaceProject.isAccessible() && (resolver = this.resolverProvider.getResolver(workspaceProject)) != null) {
                    res.add(resolver);
                }
                ++n3;
            }
        }
        return res;
    }

    public Set<IQueryWorkspaceQualifiedNameResolver> getResolversDependOn() {
        LinkedHashSet<IQueryWorkspaceQualifiedNameResolver> res = new LinkedHashSet<IQueryWorkspaceQualifiedNameResolver>();
        IProject[] iProjectArray = this.project.getReferencingProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IQueryWorkspaceQualifiedNameResolver resolver;
            IProject project = iProjectArray[n2];
            if (project.exists() && (resolver = this.resolverProvider.getResolver(project)) != null) {
                res.add(resolver);
            }
            ++n2;
        }
        return res;
    }
}

