/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.completion.proposals;

import java.util.StringJoiner;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.evaluation.QueryService;
import org.eclipse.acceleo.aql.parser.AcceleoAstSerializer;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.parser.AstSerializer;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IServiceCompletionProposal;

public class QueryServiceCompletionProposal
implements IServiceCompletionProposal {
    private final QueryService service;
    private final AstSerializer aqlSerializer = new AstSerializer();
    private final AcceleoAstSerializer accleeoSerializer = new AcceleoAstSerializer("");

    public QueryServiceCompletionProposal(QueryService queryService) {
        this.service = queryService;
    }

    public String getProposal() {
        return this.service.getName() + "()";
    }

    public int getCursorOffset() {
        int namelength = this.service.getName().length();
        if (this.service.getNumberOfParameters() == 1) {
            return namelength + 2;
        }
        return namelength + 1;
    }

    public String getDescription() {
        StringBuilder res = new StringBuilder();
        res.append(String.valueOf((Object)((Query)this.service.getOrigin()).getVisibility()) + " " + ((Query)this.service.getOrigin()).getName());
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (Variable parameter : ((Query)this.service.getOrigin()).getParameters()) {
            joiner.add(this.accleeoSerializer.serialize(parameter));
        }
        res.append(joiner.toString());
        Expression returnTypeExpression = ((Query)this.service.getOrigin()).getType().getAst();
        if (returnTypeExpression != null) {
            res.append(" = ");
            res.append(this.aqlSerializer.serialize(returnTypeExpression));
        }
        if (((Query)this.service.getOrigin()).getDocumentation() != null) {
            res.append("\n");
            res.append(((Query)this.service.getOrigin()).getDocumentation().getBody().getValue());
        }
        return res.toString();
    }

    public IService<?> getObject() {
        return this.service;
    }
}

