/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.ErrorCall;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.ICompletionResult;
import org.eclipse.acceleo.query.runtime.IProposalFilter;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.validation.type.IType;

public class CompletionResult
implements ICompletionResult {
    private final List<ICompletionProposal> proposals;
    private String prefix;
    private String remaining;
    private int replacementOffset;
    private int replacementLength;
    private IValidationResult validationResult;

    public CompletionResult(List<ICompletionProposal> proposals) {
        this(proposals, null);
    }

    public CompletionResult(List<ICompletionProposal> proposals, IValidationResult validationResult) {
        this.proposals = proposals;
        this.validationResult = validationResult;
    }

    @Override
    public List<ICompletionProposal> getProposals(IProposalFilter filter) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        for (ICompletionProposal proposal : this.proposals) {
            if (!filter.keepProposal(proposal)) continue;
            result.add(proposal);
        }
        return result;
    }

    @Override
    public void sort(Comparator<ICompletionProposal> comparator) {
        Collections.sort(this.proposals, comparator);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String getRemaining() {
        return this.remaining;
    }

    @Override
    public void setRemaining(String remaining) {
        this.remaining = remaining;
    }

    @Override
    public int getReplacementLength() {
        return this.replacementLength;
    }

    @Override
    public int getReplacementOffset() {
        return this.replacementOffset;
    }

    @Override
    public void setReplacementLength(int replacementLength) {
        this.replacementLength = replacementLength;
    }

    @Override
    public void setReplacementOffset(int offset) {
        this.replacementOffset = offset;
    }

    @Override
    public IValidationResult getIValidationResult() {
        return this.validationResult;
    }

    @Override
    public Set<IType> getPossibleReceiverTypes() {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        Error error = this.getIValidationResult().getErrorToComplete();
        if (error instanceof ErrorCall) {
            result.addAll(this.validationResult.getPossibleTypes((Expression)((ErrorCall)error).getArguments().get(0)));
        }
        return result;
    }
}

