/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ide.ui.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.query.ide.ui.dialog.CollectionContentProvider;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class QualifiedNameSelectionDialog
extends MessageDialog {
    private static final int TABLE_MINIMUM_HEIGHT = 400;
    private static final int TABLE_MINIMUM_WIDTH = 200;
    private final String defaultQualifiedName;
    private final List<String> availableQualifiedNames;
    private String selectedQualifiedName;

    public QualifiedNameSelectionDialog(Shell parentShell, String message, String defaultQualifiedName, IQualifiedNameResolver resolver) {
        super(parentShell, "Select a qualified name.", null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.defaultQualifiedName = defaultQualifiedName;
        this.availableQualifiedNames = new ArrayList<String>(resolver.getAvailableQualifiedNames());
    }

    protected Control createCustomArea(Composite parent) {
        Composite container = new Composite(parent, parent.getStyle());
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        FilteredTree filteredTree = new FilteredTree(container, 2048, new PatternFilter(), true, true);
        TreeViewer treeViewer = filteredTree.getViewer();
        Tree tree = treeViewer.getTree();
        GridData gdTable = new GridData(4, 4, true, true, 1, 1);
        gdTable.minimumWidth = 200;
        gdTable.minimumHeight = 400;
        tree.setLayoutData((Object)gdTable);
        treeViewer.setContentProvider((IContentProvider)new CollectionContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
                QualifiedNameSelectionDialog.this.selectedQualifiedName = (String)selected;
            }
        });
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                QualifiedNameSelectionDialog.this.buttonPressed(0);
            }
        });
        treeViewer.setInput(this.availableQualifiedNames);
        if (this.defaultQualifiedName != null) {
            treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.defaultQualifiedName));
        }
        return container;
    }

    public String getSelectedQualifiedName() {
        return this.selectedQualifiedName;
    }
}

