/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.breakpoints;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;

final class DocumentUtils {
    private static ITextFileBuffer toBuffer(IDocument document) {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        if (bufferManager == null) {
            return null;
        }
        return bufferManager.getTextFileBuffer(document);
    }

    public static URI toUri(IDocument document) {
        IFile file = DocumentUtils.getFile(document);
        if (file != null) {
            return DocumentUtils.toUri((IResource)file);
        }
        ITextFileBuffer buffer = DocumentUtils.toBuffer(document);
        if (buffer != null) {
            IPath path = DocumentUtils.toPath(buffer);
            if (path != null) {
                return DocumentUtils.toUri(path.toFile());
            }
            return buffer.getFileStore().toURI();
        }
        return null;
    }

    private static IPath toPath(ITextFileBuffer buffer) {
        if (buffer != null) {
            return buffer.getLocation();
        }
        return null;
    }

    private static IPath toPath(IDocument document) {
        return DocumentUtils.toPath(DocumentUtils.toBuffer(document));
    }

    private static URI toUri(IPath absolutePath) {
        return DocumentUtils.toUri(absolutePath.toFile());
    }

    private static URI toUri(IResource resource) {
        URI adaptedURI = (URI)Adapters.adapt((Object)resource, URI.class, (boolean)true);
        if (adaptedURI != null) {
            return adaptedURI;
        }
        IPath location = resource.getLocation();
        if (location != null) {
            return DocumentUtils.toUri(location);
        }
        return resource.getLocationURI();
    }

    private static URI toUri(File file) {
        try {
            return new URI("file", "", file.getAbsoluteFile().toURI().getPath(), null);
        }
        catch (URISyntaxException e) {
            return file.getAbsoluteFile().toURI();
        }
    }

    private static IFile getFile(IDocument document) {
        IPath path = DocumentUtils.toPath(document);
        return DocumentUtils.getFile(path);
    }

    private static IFile getFile(IPath path) {
        if (path == null) {
            return null;
        }
        IFile res = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (res != null && res.exists()) {
            return res;
        }
        return null;
    }

    private DocumentUtils() {
    }
}

