/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.outline;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OutlineItem {
    private OutlineItem parent;
    private final int level;
    private List<OutlineItem> children = new ArrayList<OutlineItem>();
    private final int offset;
    private int length;
    private final String id;
    private String label;
    private String kind;
    private int childOffset;
    private String tooltip;
    private Map<String, OutlineItem> itemsById;
    private String resourcePath;
    private int hash = -1;
    private String positionKey;

    public OutlineItem(OutlineItem parent, int level, String id, int offset, int length, String label) {
        this.parent = parent;
        int n = this.level = parent == null ? 0 : level;
        if (parent != null && level < parent.getLevel()) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.offset = offset;
        this.length = length;
        this.label = label;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public int getLength() {
        return this.length;
    }

    public int getSectionLength() {
        if (this.parent == null) {
            return this.length;
        }
        List<OutlineItem> siblings = this.getParent().getChildren();
        int index = siblings.indexOf(this);
        if (index < siblings.size() - 1) {
            return siblings.get(index + 1).getOffset() - this.getOffset();
        }
        int parentRelativeOffset = this.getOffset() - this.parent.getOffset();
        return this.parent.getSectionLength() - parentRelativeOffset;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getLabel() {
        return this.label;
    }

    public String getId() {
        return this.id;
    }

    public int getLevel() {
        if (this.parent == null) {
            return 0;
        }
        return this.level;
    }

    void setLength(int length) {
        this.length = length;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public OutlineItem getParent() {
        return this.parent;
    }

    public boolean isRootItem() {
        return this.parent == null;
    }

    public OutlineItem getPrevious() {
        if (this.parent == null) {
            return null;
        }
        List<OutlineItem> siblings = this.parent.getChildren();
        int index = siblings.indexOf(this);
        if (index > 0) {
            return siblings.get(index - 1);
        }
        return this.parent;
    }

    public List<OutlineItem> getChildren() {
        return this.children;
    }

    public int getOffset() {
        return this.offset;
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = this.calculatePositionKey().hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        OutlineItem otherRoot;
        OutlineItem thisRoot;
        boolean isEqual;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OutlineItem other = (OutlineItem)obj;
        boolean bl = isEqual = other.hashCode() == this.hashCode() && other.calculatePositionKey().equals(this.calculatePositionKey());
        if (isEqual && (thisRoot = this.computeRoot(this)) != (otherRoot = this.computeRoot(other)) && thisRoot.getResourcePath() != otherRoot.getResourcePath() && (thisRoot.getResourcePath() == null || !thisRoot.getResourcePath().equals(otherRoot.getResourcePath()))) {
            isEqual = false;
        }
        return isEqual;
    }

    private OutlineItem computeRoot(OutlineItem item) {
        while (!item.isRootItem()) {
            item = item.getParent();
        }
        return item;
    }

    public void clear() {
        this.children.clear();
    }

    private String calculatePositionKey() {
        if (this.positionKey == null) {
            this.positionKey = this.parent == null ? "" : this.getParent().calculatePositionKey() + "/" + this.kind + "_" + this.childOffset;
        }
        return this.positionKey;
    }

    private void addChild(OutlineItem outlineItem) {
        outlineItem.childOffset = this.children.size();
        this.children.add(outlineItem);
    }

    public OutlineItem findNearestMatchingOffset(int offset) {
        NearestItemVisitor visitor = new NearestItemVisitor(offset);
        this.accept(visitor);
        return visitor.nearest;
    }

    public OutlineItem findItemById(String id) {
        if (this.itemsById == null) {
            this.itemsById = new HashMap<String, OutlineItem>();
            this.accept(item -> {
                if (item.getId() != null) {
                    this.itemsById.put(item.getId(), item);
                }
                return true;
            });
        }
        return this.itemsById.get(id);
    }

    public int distance(int offset) {
        int startDistance = this.offset - offset;
        return startDistance;
    }

    public void accept(Visitor visitor) {
        if (visitor.visit(this)) {
            for (OutlineItem item : this.getChildren()) {
                item.accept(visitor);
            }
        }
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getResourcePath() {
        if (this.getParent() != null) {
            return this.getParent().getResourcePath();
        }
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        if (this.getParent() != null) {
            this.getParent().setResourcePath(resourcePath);
        } else {
            this.resourcePath = resourcePath;
        }
    }

    public void moveChildren(OutlineItem otherParent) {
        if (!otherParent.children.isEmpty()) {
            if (this.children.isEmpty()) {
                List<OutlineItem> temp = this.children;
                this.children = otherParent.children;
                otherParent.children = temp;
                for (OutlineItem outlineItem : this.children) {
                    outlineItem.parent = this;
                }
            } else {
                this.children.addAll(otherParent.children);
                for (OutlineItem child : otherParent.children) {
                    child.parent = this;
                }
                otherParent.children.clear();
            }
            Visitor visitor = item -> {
                item.hash = -1;
                item.positionKey = null;
                return true;
            };
            for (OutlineItem outlineItem : this.children) {
                outlineItem.accept(visitor);
            }
        } else {
            this.children.clear();
        }
        this.itemsById = null;
        this.setLength(otherParent.getLength());
    }

    public boolean contains(OutlineItem item) {
        int itemEnd;
        int end;
        if (item == this || this.isRootItem()) {
            return true;
        }
        return this.getOffset() <= item.getOffset() && (end = this.getOffset() + this.getSectionLength()) >= (itemEnd = item.getOffset() + item.getSectionLength());
    }

    public String toString() {
        return MessageFormat.format("{0} [id={1}, positionKey={2}]", this.getClass().getSimpleName(), this.getId(), this.calculatePositionKey());
    }

    private static class NearestItemVisitor
    implements Visitor {
        private OutlineItem nearest = null;
        private final int offset;

        public NearestItemVisitor(int offset) {
            this.offset = offset;
        }

        @Override
        public boolean visit(OutlineItem item) {
            if (item.isRootItem()) {
                return true;
            }
            if (this.nearest == null) {
                this.nearest = item;
                return true;
            }
            int itemDistance = item.distance(this.offset);
            if (itemDistance > 0) {
                return true;
            }
            int nearestDistance = this.nearest.distance(this.offset);
            nearestDistance = Math.abs(nearestDistance);
            if ((itemDistance = Math.abs(itemDistance)) < nearestDistance) {
                this.nearest = item;
            } else if (itemDistance > nearestDistance) {
                return false;
            }
            return true;
        }
    }

    public static interface Visitor {
        public boolean visit(OutlineItem var1);
    }
}

