/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.value;

import java.text.MessageFormat;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.data.EnumeratedType;
import org.eclipse.fordiac.ide.model.data.EnumeratedValue;
import org.eclipse.fordiac.ide.model.value.ValueConverter;

public final class EnumValueConverter
implements ValueConverter<EnumeratedValue> {
    private static final Pattern SCANNER_PATTERN = Pattern.compile("\\G\\w++");
    private final EnumeratedType type;

    public EnumValueConverter(EnumeratedType type) {
        this.type = type;
    }

    @Override
    public EnumeratedValue toValue(String string) throws IllegalArgumentException {
        return this.type.getEnumeratedValues().stream().filter(v -> v.getName().equals(string)).findFirst().orElseThrow(() -> new IllegalArgumentException(MessageFormat.format(Messages.EnumValueConverter_NoSuchValue, string, this.type.getName())));
    }

    @Override
    public EnumeratedValue toValue(Scanner scanner) throws IllegalArgumentException {
        return (EnumeratedValue)this.toValue(scanner, SCANNER_PATTERN);
    }

    @Override
    public String toString(EnumeratedValue value) {
        return value.getName();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

