/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.api.ui;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.sirius.tools.internal.ui.ExternalJavaActionDescriptor;

public final class ExternalJavaActionProvider {
    public static final ExternalJavaActionProvider INSTANCE = new ExternalJavaActionProvider();
    private Collection<ExternalJavaActionDescriptor> externalJavaActionDescriptors = new HashSet<ExternalJavaActionDescriptor>();

    private ExternalJavaActionProvider() {
    }

    public IExternalJavaAction getJavaActionById(String id) {
        for (ExternalJavaActionDescriptor javaActionMenuItemDescriptor : this.getJavaActionDescriptor()) {
            if (!javaActionMenuItemDescriptor.getId().equalsIgnoreCase(id)) continue;
            return javaActionMenuItemDescriptor.createJavaActionMenuItem();
        }
        return null;
    }

    public Collection<ExternalJavaActionDescriptor> getJavaActionDescriptor() {
        return this.externalJavaActionDescriptors;
    }

    public void addAction(ExternalJavaActionDescriptor actionDescriptor) {
        this.externalJavaActionDescriptors.add(actionDescriptor);
    }

    public void clearRegistry() {
        this.externalJavaActionDescriptors.clear();
    }

    public void removeAction(String actionClassName) {
        Iterator<ExternalJavaActionDescriptor> iterator = this.externalJavaActionDescriptors.iterator();
        while (iterator.hasNext()) {
            ExternalJavaActionDescriptor action = iterator.next();
            if (!action.getActionClass().equals(actionClassName)) continue;
            iterator.remove();
        }
    }
}

