/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.AbstractCreateElementCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;

public class CreateTransactionCommand
extends AbstractCreateElementCommand<ServiceTransaction> {
    private final FBType fbType;

    public CreateTransactionCommand(ServiceSequence sequence) {
        super(sequence.getServiceTransaction());
        this.fbType = sequence.getService().getFBType();
    }

    public CreateTransactionCommand(ServiceSequence sequence, ServiceTransaction refElement) {
        super(sequence.getServiceTransaction(), refElement);
        this.fbType = sequence.getService().getFBType();
    }

    @Override
    protected ServiceTransaction createNewElement() {
        ServiceTransaction newTransaction = LibraryElementFactory.eINSTANCE.createServiceTransaction();
        InputPrimitive primitive = LibraryElementFactory.eINSTANCE.createInputPrimitive();
        EList eventInputs = this.fbType.getService().getFBType().getInterfaceList().getEventInputs();
        if (eventInputs.isEmpty()) {
            primitive.setEvent("INIT");
        } else {
            primitive.setEvent(((Event)eventInputs.get(0)).getName());
        }
        primitive.setInterface(this.fbType.getService().getLeftInterface());
        newTransaction.setInputPrimitive(primitive);
        return newTransaction;
    }
}

