/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal;

import org.eclipse.nebula.widgets.grid.AbstractRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class ExpandToggleRenderer
extends AbstractRenderer {
    public ExpandToggleRenderer() {
        this.setSize(11, 9);
    }

    @Override
    public void paint(GC gc, Object value) {
        Color innerColor = null;
        Color outerColor = this.getDisplay().getSystemColor(18);
        innerColor = this.isHover() ? this.getDisplay().getSystemColor(25) : this.getDisplay().getSystemColor(21);
        if (this.isExpanded()) {
            this.drawLeftPointingLine(gc, innerColor, outerColor, 0);
            this.drawLeftPointingLine(gc, innerColor, outerColor, 5);
        } else {
            this.drawRightPointingLine(gc, innerColor, outerColor, 0);
            this.drawRightPointingLine(gc, innerColor, outerColor, 5);
        }
    }

    private void drawRightPointingLine(GC gc, Color innerColor, Color outerColor, int xOffset) {
        gc.setForeground(outerColor);
        gc.drawLine(this.getBounds().x + 1 + xOffset, this.getBounds().y, this.getBounds().x + 5 + xOffset, this.getBounds().y + 4);
        gc.drawLine(this.getBounds().x + 4 + xOffset, this.getBounds().y + 5, this.getBounds().x + 1 + xOffset, this.getBounds().y + 8);
        gc.drawPoint(this.getBounds().x + xOffset, this.getBounds().y + 7);
        gc.drawLine(this.getBounds().x + xOffset, this.getBounds().y + 6, this.getBounds().x + 2 + xOffset, this.getBounds().y + 4);
        gc.drawLine(this.getBounds().x + 1 + xOffset, this.getBounds().y + 3, this.getBounds().x + xOffset, this.getBounds().y + 2);
        gc.drawPoint(this.getBounds().x + xOffset, this.getBounds().y + 1);
        gc.setForeground(innerColor);
        gc.drawLine(this.getBounds().x + 1 + xOffset, this.getBounds().y + 1, this.getBounds().x + 4 + xOffset, this.getBounds().y + 4);
        gc.drawLine(this.getBounds().x + 1 + xOffset, this.getBounds().y + 2, this.getBounds().x + 3 + xOffset, this.getBounds().y + 4);
        gc.drawLine(this.getBounds().x + 3 + xOffset, this.getBounds().y + 5, this.getBounds().x + 1 + xOffset, this.getBounds().y + 7);
        gc.drawLine(this.getBounds().x + 2 + xOffset, this.getBounds().y + 5, this.getBounds().x + 1 + xOffset, this.getBounds().y + 6);
    }

    private void drawLeftPointingLine(GC gc, Color innerColor, Color outerColor, int xOffset) {
        gc.setForeground(outerColor);
        gc.drawLine(this.getBounds().x + xOffset, this.getBounds().y + 4, this.getBounds().x + 4 + xOffset, this.getBounds().y);
        gc.drawPoint(this.getBounds().x + 5 + xOffset, this.getBounds().y + 1);
        gc.drawLine(this.getBounds().x + 5 + xOffset, this.getBounds().y + 2, this.getBounds().x + 3 + xOffset, this.getBounds().y + 4);
        gc.drawPoint(this.getBounds().x + 4 + xOffset, this.getBounds().y + 5);
        gc.drawLine(this.getBounds().x + 5 + xOffset, this.getBounds().y + 6, this.getBounds().x + 5 + xOffset, this.getBounds().y + 7);
        gc.drawLine(this.getBounds().x + 4 + xOffset, this.getBounds().y + 8, this.getBounds().x + 1 + xOffset, this.getBounds().y + 5);
        gc.setForeground(innerColor);
        gc.drawLine(this.getBounds().x + 1 + xOffset, this.getBounds().y + 4, this.getBounds().x + 4 + xOffset, this.getBounds().y + 1);
        gc.drawLine(this.getBounds().x + 2 + xOffset, this.getBounds().y + 4, this.getBounds().x + 4 + xOffset, this.getBounds().y + 2);
        gc.drawLine(this.getBounds().x + 2 + xOffset, this.getBounds().y + 5, this.getBounds().x + 4 + xOffset, this.getBounds().y + 7);
        gc.drawLine(this.getBounds().x + 2 + xOffset, this.getBounds().y + 4, this.getBounds().x + 4 + xOffset, this.getBounds().y + 6);
    }

    @Override
    public Point computeSize(GC gc, int wHint, int hHint, Object value) {
        return new Point(11, 9);
    }
}

