/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.tools;

import java.util.List;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.gef.tools.ScrollingConnectionEndpointTracker;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.commands.change.AbstractReconnectConnectionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ConnectionRoutingData;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.swt.SWT;

public class FBNScrollingConnectionEndpointTracker
extends ScrollingConnectionEndpointTracker {
    private static final int MOUSE_LEFT = 1;
    private ConnectionRoutingData originalRoutingData;

    public FBNScrollingConnectionEndpointTracker(ConnectionEditPart cep) {
        super(cep);
    }

    protected boolean handleButtonDown(int button) {
        if (button == 1) {
            this.performSelection();
        }
        return super.handleButtonDown(button);
    }

    protected boolean handleDoubleClick(int button) {
        if (button == 1) {
            this.performOpen();
        }
        return true;
    }

    protected void performSelection() {
        EditPartViewer viewer = this.getCurrentViewer();
        List selectedObjects = viewer.getSelectedEditParts();
        if (this.getCurrentInput().isModKeyDown(SWT.MOD1) && !this.getCurrentInput().isModKeyDown(SWT.MOD3)) {
            if (selectedObjects.contains(this.getConnectionEditPart())) {
                viewer.deselect((EditPart)this.getConnectionEditPart());
            } else {
                viewer.appendSelection((EditPart)this.getConnectionEditPart());
            }
        } else if (this.getCurrentInput().isShiftKeyDown()) {
            viewer.appendSelection((EditPart)this.getConnectionEditPart());
        } else {
            viewer.select((EditPart)this.getConnectionEditPart());
        }
    }

    protected boolean handleDragStarted() {
        Connection conn = this.get4diacConnection();
        if (conn != null) {
            this.originalRoutingData = (ConnectionRoutingData)EcoreUtil.copy((EObject)conn.getRoutingData());
        }
        return super.handleDragStarted();
    }

    protected void executeCurrentCommand() {
        if (this.shouldRestoreRoutingData()) {
            this.get4diacConnection().setRoutingData(this.originalRoutingData);
        }
        super.executeCurrentCommand();
    }

    protected Insets getCanvasBorder() {
        Connection conn = this.get4diacConnection();
        if (conn != null) {
            conn.getRoutingData().setNeedsValidation(true);
            if (conn.getRoutingData().is3SegementData() && "Reconnection source".equals(this.getCommandName())) {
                Insets adjustedBorder = new Insets(super.getCanvasBorder());
                adjustedBorder.right += FBNScrollingConnectionEndpointTracker.toScreen(conn.getRoutingData().getDx1());
                return adjustedBorder;
            }
            if (conn.getRoutingData().is5SegementData()) {
                return this.get5SegmentCanvasBorder(conn.getRoutingData());
            }
        }
        return super.getCanvasBorder();
    }

    private Insets get5SegmentCanvasBorder(ConnectionRoutingData routingData) {
        Insets adjustedBorder = new Insets(super.getCanvasBorder());
        if ("Reconnection source".equals(this.getCommandName())) {
            adjustedBorder.right += FBNScrollingConnectionEndpointTracker.toScreen(routingData.getDx1());
            if (routingData.getDy() < 0.0) {
                adjustedBorder.top -= FBNScrollingConnectionEndpointTracker.toScreen(routingData.getDy());
            }
        }
        if ("Reconnection target".equals(this.getCommandName())) {
            adjustedBorder.left += FBNScrollingConnectionEndpointTracker.toScreen(routingData.getDx2());
        }
        return adjustedBorder;
    }

    private boolean shouldRestoreRoutingData() {
        Connection con = this.get4diacConnection();
        if (con != null) {
            Command curCommand = this.getCurrentCommand();
            if (curCommand == null || !curCommand.canExecute()) {
                return true;
            }
            if (curCommand instanceof AbstractReconnectConnectionCommand) {
                AbstractReconnectConnectionCommand cmd = (AbstractReconnectConnectionCommand)curCommand;
                return con.getSource().equals(cmd.getNewSource()) && con.getDestination().equals(cmd.getNewDestination());
            }
        }
        return false;
    }

    protected Connection get4diacConnection() {
        Object object = this.getConnectionEditPart().getModel();
        if (object instanceof Connection) {
            Connection conn = (Connection)object;
            return conn;
        }
        return null;
    }

    private void performOpen() {
        SelectionRequest request = new SelectionRequest();
        request.setLocation(this.getLocation());
        request.setType((Object)"open");
        this.getConnectionEditPart().performRequest((Request)request);
    }

    private static int toScreen(double val) {
        return CoordinateConverter.INSTANCE.iec61499ToScreen(val);
    }
}

