/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.policies;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.application.commands.MoveAndReconnectCommand;
import org.eclipse.fordiac.ide.application.commands.ResizeGroupOrSubappCommand;
import org.eclipse.fordiac.ide.application.policies.ContainerContentLayoutPolicy;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class SubAppContentLayoutEditPolicy
extends ContainerContentLayoutPolicy {
    @Override
    protected Command getAddCommand(Request request) {
        List editParts;
        List<? extends EditPart> addTo;
        if (this.isDragAndDropRequestForSubapp(request) && !(addTo = SubAppContentLayoutEditPolicy.collectAddToElements(editParts = ((ChangeBoundsRequest)request).getEditParts())).isEmpty()) {
            Point destination = this.getTranslatedAndZoomedPoint((ChangeBoundsRequest)request);
            SubAppContentLayoutEditPolicy.translateToRelative(this.getHost(), destination);
            List<FBNetworkElement> elements = editParts.stream().map(EditPart::getModel).filter(FBNetworkElement.class::isInstance).map(FBNetworkElement.class::cast).toList();
            return new ResizeGroupOrSubappCommand(this.getHost(), new MoveAndReconnectCommand(elements, destination, this.getParentModel().getSubAppNetwork()));
        }
        return super.getAddCommand(request);
    }

    protected SubApp getParentModel() {
        return (SubApp)super.getParentModel();
    }

    private boolean isDragAndDropRequestForSubapp(Request request) {
        return request instanceof ChangeBoundsRequest && this.getHost() == this.getTargetEditPart(request);
    }

    private static List<? extends EditPart> collectAddToElements(List<? extends EditPart> editParts) {
        return editParts.stream().filter(ep -> ep.getModel() instanceof FBNetworkElement).toList();
    }
}

