/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.actions;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.actions.CopyPasteData;
import org.eclipse.fordiac.ide.application.commands.CopyElementsToGroupCommand;
import org.eclipse.fordiac.ide.application.commands.PasteCommand;
import org.eclipse.fordiac.ide.application.commands.ResizeGroupOrSubappCommand;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.application.editparts.AbstractContainerContentEditPart;
import org.eclipse.fordiac.ide.application.editparts.GroupContentEditPart;
import org.eclipse.fordiac.ide.application.editparts.UnfoldedSubappContentEditPart;
import org.eclipse.fordiac.ide.application.utilities.GetEditPartFromGraficalViewerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.ui.FordiacClipboard;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class PasteEditPartsAction
extends SelectionAction {
    private org.eclipse.swt.graphics.Point pasteRefPosition;

    public PasteEditPartsAction(IWorkbenchPart editor) {
        super(editor);
    }

    protected boolean calculateEnabled() {
        FBNetwork fbNetwork = this.getFBNetwork();
        return fbNetwork != null && !PasteEditPartsAction.getClipboardContents().isEmpty();
    }

    protected Command createPasteCommand() {
        FBNetwork fbNetwork = this.getFBNetwork();
        if (fbNetwork != null) {
            GraphicalViewer graphicalViewer;
            EditPart editPart;
            AbstractContainerContentEditPart editPart2 = GetEditPartFromGraficalViewerHelper.findAbstractContainerContentEditPartAtPosition((IEditorPart)this.getWorkbenchPart(), new Point(this.pasteRefPosition.x, this.pasteRefPosition.y), fbNetwork);
            if (editPart2 != null) {
                Command cmd = null;
                if (editPart2 instanceof GroupContentEditPart) {
                    GroupContentEditPart groupEP = (GroupContentEditPart)editPart2;
                    if (PasteEditPartsAction.getClipboardContents().elements().stream().noneMatch(Group.class::isInstance)) {
                        cmd = this.createPasteCommandForGroup(groupEP);
                    }
                }
                if (editPart2 instanceof UnfoldedSubappContentEditPart) {
                    UnfoldedSubappContentEditPart subAppEP = (UnfoldedSubappContentEditPart)editPart2;
                    cmd = this.createPasteCommandForSubApp(subAppEP);
                }
                if (cmd != null) {
                    return new ResizeGroupOrSubappCommand((GraphicalEditPart)editPart2, cmd);
                }
            }
            if ((editPart = (graphicalViewer = (GraphicalViewer)this.getWorkbenchPart().getAdapter(GraphicalViewer.class)).getEditPartForModel((Object)fbNetwork)) instanceof GraphicalEditPart) {
                GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPart;
                this.pasteRefPosition = this.getSnapCorrectPastePos(graphicalEditPart);
            }
            return new PasteCommand(PasteEditPartsAction.getClipboardContents(), fbNetwork, this.pasteRefPosition);
        }
        return new CompoundCommand();
    }

    private Command createPasteCommandForSubApp(UnfoldedSubappContentEditPart subAppContentEP) {
        Point subAppOffset = PasteEditPartsAction.getOffsetPosition((GraphicalEditPart)subAppContentEP);
        org.eclipse.swt.graphics.Point pastePointInSubApp = this.getSnapCorrectPastePos((GraphicalEditPart)subAppContentEP);
        pastePointInSubApp.x -= subAppOffset.x;
        pastePointInSubApp.y -= subAppOffset.y;
        return new PasteCommand(PasteEditPartsAction.getClipboardContents(), subAppContentEP.getModel(), pastePointInSubApp);
    }

    private Command createPasteCommandForGroup(GroupContentEditPart group) {
        PasteCommand pasteCommand = new PasteCommand(PasteEditPartsAction.getClipboardContents(), group.getModel().getGroup().getFbNetwork(), this.getSnapCorrectPastePos((GraphicalEditPart)group));
        return new CopyElementsToGroupCommand(group.getModel().getGroup(), pasteCommand, PasteEditPartsAction.getOffsetPosition((GraphicalEditPart)group));
    }

    private org.eclipse.swt.graphics.Point getSnapCorrectPastePos(GraphicalEditPart gep) {
        SnapToHelper helper = (SnapToHelper)gep.getAdapter(SnapToHelper.class);
        if (helper != null) {
            Point refPoint = new Point(this.pasteRefPosition.x, this.pasteRefPosition.y);
            gep.getFigure().translateToAbsolute((Translatable)refPoint);
            PrecisionPoint preciseLocation = new PrecisionPoint(refPoint);
            PrecisionPoint result = new PrecisionPoint(refPoint);
            helper.snapPoint(null, 192, preciseLocation, result);
            gep.getFigure().translateToRelative((Translatable)result);
            return new org.eclipse.swt.graphics.Point(result.x, result.y);
        }
        return this.pasteRefPosition;
    }

    private static Point getOffsetPosition(GraphicalEditPart gep) {
        return gep.getFigure().getClientArea().getTopLeft();
    }

    private static CopyPasteData getClipboardContents() {
        Object obj = FordiacClipboard.INSTANCE.getGraphicalContents();
        if (obj instanceof CopyPasteData) {
            CopyPasteData copyPasteMessage = (CopyPasteData)obj;
            return copyPasteMessage;
        }
        return CopyPasteData.EMPTY_COPY_PASTE_DATA;
    }

    protected void init() {
        this.setId(ActionFactory.PASTE.getId());
        this.setText(Messages.PasteEditPartsAction_Text);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof FigureCanvas) {
            this.setMouseLocationAsPastePos(event);
        }
        super.runWithEvent(event);
    }

    public void setMouseLocationAsPastePos(Event event) {
        FigureCanvas figureCanvas = (FigureCanvas)event.widget;
        Point viewLocation = figureCanvas.getViewport().getViewLocation();
        org.eclipse.swt.graphics.Point mouseLocation = Display.getCurrent().getCursorLocation();
        mouseLocation = figureCanvas.toControl(mouseLocation.x, mouseLocation.y);
        if (figureCanvas.getBounds().contains(mouseLocation.x, mouseLocation.y)) {
            ZoomManager zoomManager = ((FBNetworkEditor)this.getWorkbenchPart()).getZoomManger();
            mouseLocation.x += viewLocation.x;
            mouseLocation.y += viewLocation.y;
            this.setPastRefPosition(new Point(mouseLocation.x, mouseLocation.y).scale(1.0 / zoomManager.getZoom()));
        } else {
            Dimension visibleArea = figureCanvas.getViewport().getSize();
            this.setPastRefPosition(new org.eclipse.swt.graphics.Point(viewLocation.x + visibleArea.width / 2, viewLocation.y + visibleArea.height / 2));
        }
    }

    public void run() {
        FordiacClipboard clipboard = FordiacClipboard.INSTANCE;
        if (clipboard.getGraphicalContents() instanceof CopyPasteData) {
            this.execute(this.createPasteCommand());
        }
        this.pasteRefPosition = null;
    }

    private FBNetwork getFBNetwork() {
        if (this.getWorkbenchPart() instanceof IEditorPart) {
            return (FBNetwork)this.getWorkbenchPart().getAdapter(FBNetwork.class);
        }
        return null;
    }

    public void setPastRefPosition(org.eclipse.swt.graphics.Point pt) {
        this.pasteRefPosition = pt;
    }

    public void setPastRefPosition(Point point) {
        this.setPastRefPosition(new org.eclipse.swt.graphics.Point(point.x, point.y));
    }
}

