/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.PolylineEdgeRouter;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.OrthogonalRoutingGenerator;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.direction.RoutingDirection;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class OrthogonalEdgeRouter
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> HYPEREDGE_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addBefore((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutProcessorFactory)IntermediateProcessorStrategy.HYPEREDGE_DUMMY_MERGER);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> INVERTED_PORT_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addBefore((Enum)LayeredPhases.P3_NODE_ORDERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.INVERTED_PORT_PROCESSOR);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> NORTH_SOUTH_PORT_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addBefore((Enum)LayeredPhases.P3_NODE_ORDERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.NORTH_SOUTH_PORT_PREPROCESSOR).addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.NORTH_SOUTH_PORT_POSTPROCESSOR);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> HIERARCHICAL_PORT_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addBefore((Enum)LayeredPhases.P3_NODE_ORDERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.HIERARCHICAL_PORT_CONSTRAINT_PROCESSOR).addBefore((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutProcessorFactory)IntermediateProcessorStrategy.HIERARCHICAL_PORT_DUMMY_SIZE_PROCESSOR).addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.HIERARCHICAL_PORT_ORTHOGONAL_EDGE_ROUTER);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> SELF_LOOP_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addBefore((Enum)LayeredPhases.P1_CYCLE_BREAKING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.SELF_LOOP_PREPROCESSOR).addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.SELF_LOOP_POSTPROCESSOR).before((Enum)LayeredPhases.P4_NODE_PLACEMENT).add((ILayoutProcessorFactory)IntermediateProcessorStrategy.SELF_LOOP_PORT_RESTORER).add((ILayoutProcessorFactory)IntermediateProcessorStrategy.SELF_LOOP_ROUTER);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> HYPERNODE_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.HYPERNODE_PROCESSOR);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> CENTER_EDGE_LABEL_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addBefore((Enum)LayeredPhases.P2_LAYERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LABEL_DUMMY_INSERTER).addBefore((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LABEL_DUMMY_SWITCHER).addBefore((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LABEL_SIDE_SELECTOR).addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LABEL_DUMMY_REMOVER);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> END_EDGE_LABEL_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addBefore((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LABEL_SIDE_SELECTOR).addBefore((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutProcessorFactory)IntermediateProcessorStrategy.END_LABEL_PREPROCESSOR).addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.END_LABEL_POSTPROCESSOR);

    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        Set graphProperties = (Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        LayoutProcessorConfiguration configuration = LayoutProcessorConfiguration.create();
        if (graphProperties.contains((Object)GraphProperties.HYPEREDGES)) {
            configuration.addAll(HYPEREDGE_PROCESSING_ADDITIONS);
            configuration.addAll(INVERTED_PORT_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.NON_FREE_PORTS) || ((Boolean)graph.getProperty(LayeredOptions.FEEDBACK_EDGES)).booleanValue()) {
            configuration.addAll(INVERTED_PORT_PROCESSING_ADDITIONS);
            if (graphProperties.contains((Object)GraphProperties.NORTH_SOUTH_PORTS)) {
                configuration.addAll(NORTH_SOUTH_PORT_PROCESSING_ADDITIONS);
            }
        }
        if (graphProperties.contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            configuration.addAll(HIERARCHICAL_PORT_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.SELF_LOOPS)) {
            configuration.addAll(SELF_LOOP_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.HYPERNODES)) {
            configuration.addAll(HYPERNODE_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.CENTER_LABELS)) {
            configuration.addAll(CENTER_EDGE_LABEL_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.END_LABELS)) {
            configuration.addAll(END_EDGE_LABEL_PROCESSING_ADDITIONS);
        }
        return configuration;
    }

    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Orthogonal edge routing", 1.0f);
        double nodeNodeSpacing = (Double)layeredGraph.getProperty(LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        double edgeEdgeSpacing = (Double)layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_EDGE_BETWEEN_LAYERS);
        double edgeNodeSpacing = (Double)layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS);
        OrthogonalRoutingGenerator routingGenerator = new OrthogonalRoutingGenerator(RoutingDirection.WEST_TO_EAST, edgeEdgeSpacing, "phase5");
        float xpos = 0.0f;
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        Layer leftLayer = null;
        Layer rightLayer = null;
        List<LNode> leftLayerNodes = null;
        List<LNode> rightLayerNodes = null;
        int leftLayerIndex = -1;
        int rightLayerIndex = -1;
        do {
            boolean isRightLayerExternal;
            rightLayer = layerIter.hasNext() ? layerIter.next() : null;
            rightLayerNodes = rightLayer == null ? null : rightLayer.getNodes();
            rightLayerIndex = layerIter.previousIndex();
            if (leftLayer != null) {
                LGraphUtil.placeNodesHorizontally(leftLayer, xpos);
                xpos = (float)((double)xpos + leftLayer.getSize().x);
            }
            double startPos = leftLayer == null ? (double)xpos : (double)xpos + edgeNodeSpacing;
            int slotsCount = routingGenerator.routeEdges(monitor, layeredGraph, leftLayerNodes, leftLayerIndex, rightLayerNodes, startPos);
            boolean isLeftLayerExternal = leftLayer == null || Iterables.all(leftLayerNodes, PolylineEdgeRouter.PRED_EXTERNAL_WEST_OR_EAST_PORT);
            boolean bl = isRightLayerExternal = rightLayer == null || Iterables.all(rightLayerNodes, PolylineEdgeRouter.PRED_EXTERNAL_WEST_OR_EAST_PORT);
            if (slotsCount > 0) {
                double routingWidth = (double)(slotsCount - 1) * edgeEdgeSpacing;
                if (leftLayer != null) {
                    routingWidth += edgeNodeSpacing;
                }
                if (rightLayer != null) {
                    routingWidth += edgeNodeSpacing;
                }
                if (routingWidth < nodeNodeSpacing && !isLeftLayerExternal && !isRightLayerExternal) {
                    routingWidth = nodeNodeSpacing;
                }
                xpos = (float)((double)xpos + routingWidth);
            } else if (!isLeftLayerExternal && !isRightLayerExternal) {
                xpos = (float)((double)xpos + nodeNodeSpacing);
            }
            leftLayer = rightLayer;
            leftLayerNodes = rightLayerNodes;
            leftLayerIndex = rightLayerIndex;
        } while (rightLayer != null);
        layeredGraph.getSize().x = xpos;
        monitor.done();
    }
}

