/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.model.ConnectionLayoutTagger;
import org.eclipse.fordiac.ide.model.commands.QualNameChangeListenerManager;
import org.eclipse.fordiac.ide.model.errormarker.FordiacErrorMarker;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.Messages;
import org.eclipse.fordiac.ide.model.ui.editors.BreadcrumbNavigationLocation;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.fordiac.ide.model.ui.widgets.BreadcrumbWidget;
import org.eclipse.fordiac.ide.model.ui.widgets.GoIntoSubappSelectionEvent;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.editors.AbstractCloseAbleFormEditor;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public abstract class AbstractBreadCrumbEditor
extends AbstractCloseAbleFormEditor
implements CommandStackEventListener,
ITabbedPropertySheetPageContributor,
IGotoMarker,
INavigationLocationProvider,
IPersistableEditor {
    private static final String TAG_BREADCRUMB_HIERACHY = "FORDIAC_BREADCRUMB_HIERACHY";
    private static final String TAG_GRAPHICAL_VIEWER_ZOOM = "FORDIAC_GRAPHICAL_VIEWER_ZOOM";
    private static final String TAG_GRAPHICAL_VIEWER_HOR_SCROLL = "FORDIAC_GRAPHICAL_VIEWER_HOR_SCROLL";
    private static final String TAG_GRAPHICAL_VIEWER_VER_SCROLL = "FORDIAC_GRAPHICAL_VIEWER_VER_SCROLL";
    private Map<Object, Integer> modelToEditorNum = new HashMap<Object, Integer>();
    private BreadcrumbWidget breadcrumb;
    private IMemento memento;
    private Command layoutCommand;

    public BreadcrumbWidget getBreadcrumb() {
        return this.breadcrumb;
    }

    protected Map<Object, Integer> getModelToEditorNumMapping() {
        return this.modelToEditorNum;
    }

    public void createPartControl(Composite parent) {
        Object initialModel;
        parent.setLayout((Layout)GridLayoutFactory.fillDefaults().equalWidth(true).spacing(0, 0).create());
        this.breadcrumb = new BreadcrumbWidget(parent);
        super.createPartControl(parent);
        ((CTabFolder)this.getContainer()).setTabHeight(0);
        this.initializeBreadcrumb();
        String itemPath = null;
        if (this.memento != null) {
            itemPath = this.memento.getString(TAG_BREADCRUMB_HIERACHY);
        }
        if ((initialModel = this.getInitialModel(itemPath)) != null) {
            this.setInitialModel(initialModel);
        }
        this.memento = null;
        this.breadcrumb.addSelectionChangedListener(this::handleBreadCrumbSelection);
    }

    private void initializeBreadcrumb() {
        this.getBreadcrumb().setContentProvider(this.createBreadcrumbContentProvider());
        this.getBreadcrumb().setLabelProvider(this.createBreadcrumbLabelProvider());
    }

    protected void setInitialModel(Object model) {
        this.getBreadcrumb().setInput(model);
        int pagenum = this.modelToEditorNum.computeIfAbsent(model, this::createEditor);
        if (-1 != pagenum) {
            this.setActivePage(pagenum);
            GraphicalViewer viewer = (GraphicalViewer)this.getEditor(pagenum).getAdapter(GraphicalViewer.class);
            if (viewer != null && this.memento != null) {
                AbstractBreadCrumbEditor.restoreGraphicalViewerState(viewer, this.memento);
            }
        }
    }

    protected Composite createPageContainer(Composite parent) {
        Composite pageContainer = new Composite(parent, 0);
        pageContainer.setLayoutData((Object)new GridData(1808));
        return pageContainer;
    }

    protected void handleBreadCrumbSelection(SelectionChangedEvent event) {
        SubApp subapp;
        Object element = ((StructuredSelection)event.getSelection()).getFirstElement();
        if (element instanceof SubApp && (subapp = (SubApp)element).isUnfolded() && !(event instanceof GoIntoSubappSelectionEvent)) {
            this.showAndSelectExpandedSubapp(subapp);
        } else {
            this.openEditor(element);
        }
    }

    private void showAndSelectExpandedSubapp(SubApp subapp) {
        EObject container = AbstractBreadCrumbEditor.getFBNetworkContainer((EObject)subapp);
        this.breadcrumb.setInput(container, null);
        this.openEditor(container);
        HandlerHelper.showExpandedSubapp(subapp, (IEditorPart)this);
    }

    private void openEditor(Object element) {
        int pagenum = this.modelToEditorNum.computeIfAbsent(element, this::createEditor);
        if (-1 != pagenum) {
            this.setActivePage(pagenum);
            this.getSite().getPage().getNavigationHistory().markLocation(this.getNavigationLocationProvider());
        }
    }

    protected IEditorPart getNavigationLocationProvider() {
        IWorkbenchPart iWorkbenchPart = this.getSite().getPart();
        if (iWorkbenchPart instanceof IEditorPart) {
            IEditorPart editorPart = (IEditorPart)iWorkbenchPart;
            return editorPart;
        }
        return this;
    }

    private int createEditor(Object model) {
        EditorPart part = this.createEditorPart(model);
        if (part != null) {
            IEditorInput input = this.createEditorInput(model);
            try {
                return this.addPage((IEditorPart)part, input);
            }
            catch (PartInitException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
        }
        return -1;
    }

    public boolean closeChildEditor(IEditorPart childEditor) {
        int pageIndex = this.pages.indexOf(childEditor);
        if (pageIndex != -1) {
            this.removePage(pageIndex);
            this.updateEditorMapping(pageIndex);
            return true;
        }
        return false;
    }

    private void updateEditorMapping(int pageIndex) {
        HashMap<Object, Integer> newModelToEditorNum = new HashMap<Object, Integer>();
        this.modelToEditorNum.forEach((obj, index) -> {
            int intIndex = index;
            if (intIndex != pageIndex) {
                if (intIndex < pageIndex) {
                    newModelToEditorNum.put(obj, intIndex);
                } else {
                    newModelToEditorNum.put(obj, intIndex - 1);
                }
            }
        });
        this.modelToEditorNum = newModelToEditorNum;
    }

    public boolean isDirty() {
        return this.getCommandStack() != null && this.getCommandStack().isDirty();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == CommandStack.class) {
            return adapter.cast(this.getCommandStack());
        }
        if (adapter == IGotoMarker.class) {
            return adapter.cast(this.getNavigationLocationProvider());
        }
        return (T)super.getAdapter(adapter);
    }

    public void stackChanged(CommandStackEvent event) {
        if (AbstractBreadCrumbEditor.isConnectionLayoutPreferenceTicked() && AbstractBreadCrumbEditor.isTagged(event)) {
            if (event.isPostChangeEvent()) {
                if (event.getDetail() == 8) {
                    GraphicalViewer viewer = (GraphicalViewer)this.getActiveEditor().getAdapter(GraphicalViewer.class);
                    if (viewer != null) {
                        viewer.flush();
                        this.layoutCommand = AbstractBreadCrumbEditor.createConnectionLayoutCommand();
                        this.layoutCommand.execute();
                    }
                } else if (this.layoutCommand != null && event.getDetail() == 16) {
                    this.layoutCommand.redo();
                }
            } else if (event.isPreChangeEvent() && this.layoutCommand != null && event.getDetail() == 4) {
                this.layoutCommand.undo();
            }
        }
    }

    private static boolean isTagged(CommandStackEvent event) {
        block2: {
            block3: {
                if (event.getCommand() instanceof ConnectionLayoutTagger) break block2;
                Command command = event.getCommand();
                if (!(command instanceof CompoundCommand)) break block3;
                CompoundCommand compoundCommand = (CompoundCommand)command;
                if (compoundCommand.getCommands().stream().anyMatch(ConnectionLayoutTagger.class::isInstance)) break block2;
            }
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.getCommandStack() != null) {
            QualNameChangeListenerManager.INSTANCE.removeCommandStackEventListener(this.getCommandStack(), (Object)this.getAdapter(LibraryElement.class).getTypeEntry());
            this.getCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
        }
        super.dispose();
    }

    public void gotoMarker(IMarker marker) {
        EObject target = FordiacErrorMarker.getTargetRelative((IMarker)marker, (LibraryElement)this.getAdapter(LibraryElement.class));
        this.gotoElement(target);
    }

    private void gotoElement(EObject element) {
        EObject toView = AbstractBreadCrumbEditor.getFBNetworkContainer(element);
        if (toView != null) {
            this.getBreadcrumb().setInput(toView);
            this.selectElement(element);
        }
    }

    protected void selectElement(EObject element) {
        if (element instanceof Connection) {
            Connection conn = (Connection)element;
            if (conn.getSourceElement() != null) {
                HandlerHelper.selectElement((Object)conn.getSourceElement(), (IEditorPart)this);
            } else if (conn.getDestinationElement() != null) {
                HandlerHelper.selectElement((Object)conn.getDestinationElement(), (IEditorPart)this);
            }
        }
        while (element != null && !HandlerHelper.selectElement((Object)element, (IEditorPart)this)) {
            element = element.eContainer();
        }
    }

    private static EObject getFBNetworkContainer(EObject object) {
        while (object != null) {
            SubApp subApp;
            EObject eObject;
            if (!((object = object.eContainer()) instanceof FBNetwork) || (eObject = object.eContainer()) instanceof SubApp && (subApp = (SubApp)eObject).isUnfolded()) continue;
            return object.eContainer();
        }
        return null;
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return null;
    }

    public INavigationLocation createNavigationLocation() {
        if (this.breadcrumb != null) {
            Object modelItem = this.breadcrumb.getActiveItem().getModel();
            return modelItem != null ? new BreadcrumbNavigationLocation(this) : null;
        }
        return null;
    }

    public void saveState(IMemento memento) {
        if (this.getBreadcrumb() != null) {
            memento.putString(TAG_BREADCRUMB_HIERACHY, BreadcrumbNavigationLocation.generateItemPath(this.getBreadcrumb()).substring(1));
            GraphicalViewer viewer = (GraphicalViewer)this.getActiveEditor().getAdapter(GraphicalViewer.class);
            if (viewer != null) {
                AbstractBreadCrumbEditor.saveGraphicalViewerState(viewer, memento);
            }
        }
    }

    protected static void saveGraphicalViewerState(GraphicalViewer viewer, IMemento memento) {
        Control control;
        if (viewer.getRootEditPart() instanceof ScalableFreeformRootEditPart) {
            memento.putFloat(TAG_GRAPHICAL_VIEWER_ZOOM, (float)((ScalableFreeformRootEditPart)viewer.getRootEditPart()).getZoomManager().getZoom());
        }
        if ((control = viewer.getControl()) instanceof FigureCanvas) {
            FigureCanvas canvas = (FigureCanvas)control;
            Point location = canvas.getViewport().getViewLocation();
            memento.putInteger(TAG_GRAPHICAL_VIEWER_HOR_SCROLL, location.x);
            memento.putInteger(TAG_GRAPHICAL_VIEWER_VER_SCROLL, location.y);
        }
    }

    public void restoreState(IMemento memento) {
        this.memento = memento;
    }

    private static void restoreGraphicalViewerState(GraphicalViewer viewer, IMemento memento) {
        Control control;
        RootEditPart rootEditPart = viewer.getRootEditPart();
        if (rootEditPart instanceof ScalableFreeformRootEditPart) {
            ScalableFreeformRootEditPart scalableFreeformRootEditPart = (ScalableFreeformRootEditPart)rootEditPart;
            Float zoom = memento.getFloat(TAG_GRAPHICAL_VIEWER_ZOOM);
            if (zoom != null) {
                scalableFreeformRootEditPart.getZoomManager().setZoom(zoom.doubleValue());
            }
        }
        if ((control = viewer.getControl()) instanceof FigureCanvas) {
            FigureCanvas canvas = (FigureCanvas)control;
            Integer xLocation = memento.getInteger(TAG_GRAPHICAL_VIEWER_HOR_SCROLL);
            Integer yLocation = memento.getInteger(TAG_GRAPHICAL_VIEWER_VER_SCROLL);
            if (xLocation != null && yLocation != null) {
                Display.getDefault().asyncExec(() -> {
                    if (!canvas.isDisposed()) {
                        canvas.scrollTo(xLocation.intValue(), yLocation.intValue());
                    }
                });
            }
        }
    }

    private static boolean isConnectionLayoutPreferenceTicked() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.fordiac.ide.gef", "ConnectionAutoLayout", false, null);
    }

    private static Command createConnectionLayoutCommand() {
        IHandlerService handlerService = AbstractBreadCrumbEditor.getHandlerService();
        try {
            Event mule = new Event();
            handlerService.executeCommand("org.eclipse.fordiac.ide.elk.connectionLayoutMule", mule);
            return (Command)mule.data;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not execute layout command", ex);
        }
    }

    private static IHandlerService getHandlerService() {
        return (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getService(IHandlerService.class);
    }

    protected void showReloadErrorMessage(String path, String whatEditor) {
        String printPath = path.substring(1);
        printPath = printPath.replace('/', '.');
        MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)Messages.AutoReloadError_PathNotFound_Title, (String)MessageFormat.format(Messages.AutoReloadError_PathNotFound, printPath, whatEditor));
    }

    public abstract CommandStack getCommandStack();

    protected abstract EditorPart createEditorPart(Object var1);

    protected abstract IEditorInput createEditorInput(Object var1);

    protected abstract AdapterFactoryContentProvider createBreadcrumbContentProvider();

    protected abstract AdapterFactoryLabelProvider createBreadcrumbLabelProvider();

    protected abstract Object getInitialModel(String var1);
}

