/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties;

import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeConditionEventCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeECTransitionCommentCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider.ECCContentAndLabelProvider;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeConditionExpressionCommand;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.structuredtextalgorithm.ui.editor.embedded.STAlgorithmConditionEditedResourceProvider;
import org.eclipse.fordiac.ide.structuredtextalgorithm.ui.editor.embedded.STAlgorithmEmbeddedEditorUtil;
import org.eclipse.fordiac.ide.ui.providers.SourceViewerColorProvider;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;

public class TransitionSection
extends AbstractSection {
    private Text commentText;
    private Composite conditionEditingContainer;
    private CCombo eventCombo;
    private EmbeddedEditor conditionEditor;
    private EmbeddedEditorModelAccess conditionEditorModelAccess;

    protected ECTransition getType() {
        return (ECTransition)this.type;
    }

    protected BasicFBType getBasicFBType() {
        ECC ecc;
        ECTransition type = this.getType();
        if (type != null && (ecc = type.getECC()) != null) {
            return ecc.getBasicFBType();
        }
        return null;
    }

    protected Object getInputType(Object input) {
        if (input instanceof EditPart) {
            EditPart ep = (EditPart)input;
            input = ep.getModel();
        }
        if (input instanceof ECTransition) {
            return input;
        }
        return null;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createComposite(parent);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)composite);
        this.getWidgetFactory().createCLabel(composite, Messages.TransitionSection_Condition);
        this.createConditionEditingContainer(composite);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.conditionEditingContainer);
        this.getWidgetFactory().createCLabel(composite, Messages.TransitionSection_Comment);
        this.commentText = this.createGroupText(composite, true);
        this.commentText.addModifyListener(event -> {
            this.removeContentAdapter();
            this.executeCommand(new ChangeECTransitionCommentCommand(this.getType(), this.commentText.getText()));
            this.addContentAdapter();
        });
    }

    private void createConditionEditingContainer(Composite parent) {
        this.conditionEditingContainer = this.getWidgetFactory().createComposite(parent);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(this.conditionEditingContainer);
        this.eventCombo = ComboBoxWidgetFactory.createCombo((TabbedPropertySheetWidgetFactory)this.getWidgetFactory(), (Composite)this.conditionEditingContainer);
        this.eventCombo.addListener(13, event -> {
            this.removeContentAdapter();
            this.executeCommand(new ChangeConditionEventCommand(this.getType(), this.eventCombo.getText()));
            this.updateConditionEditor();
            this.addContentAdapter();
        });
        this.getWidgetFactory().createCLabel(this.conditionEditingContainer, "[");
        this.createConditionEditor(this.conditionEditingContainer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.conditionEditor.getViewer().getControl());
        this.getWidgetFactory().createCLabel(this.conditionEditingContainer, "]");
    }

    protected void createConditionEditor(Composite parent) {
        STAlgorithmConditionEditedResourceProvider editedResourceProvider = new STAlgorithmConditionEditedResourceProvider((LibraryElement)this.getBasicFBType(), Collections.emptySet(), (LibraryElement)IecTypes.ElementaryTypes.BOOL);
        this.conditionEditor = STAlgorithmEmbeddedEditorUtil.getEmbeddedEditorFactory().newEditor((IEditedResourceProvider)editedResourceProvider).withStyle(2052).withParent(parent);
        this.conditionEditorModelAccess = this.conditionEditor.createPartialEditor();
        this.conditionEditor.getViewer().setEditable(false);
        this.conditionEditor.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                TransitionSection.this.removeContentAdapter();
                if (TransitionSection.this.conditionEditorModelAccess.getEditablePart().contentEquals("")) {
                    if (!ECCContentAndLabelProvider.isOneConditionExpression(TransitionSection.this.getType()) || TransitionSection.this.getType().getConditionEvent() != null) {
                        TransitionSection.this.executeCommand((Command)new ChangeConditionExpressionCommand(TransitionSection.this.getType(), ""));
                    }
                } else {
                    TransitionSection.this.executeCommand((Command)new ChangeConditionExpressionCommand(TransitionSection.this.getType(), TransitionSection.this.conditionEditorModelAccess.getEditablePart()));
                }
                TransitionSection.this.addContentAdapter();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        SourceViewerColorProvider.initializeSourceViewerColors((ISourceViewer)this.conditionEditor.getViewer());
    }

    protected void updateConditionEditor() {
        if (ECCContentAndLabelProvider.isOneConditionExpression(this.getType())) {
            this.conditionEditorModelAccess.updateModel("");
            this.conditionEditor.getViewer().setEditable(false);
        } else {
            this.conditionEditorModelAccess.updateModel(this.getType().getConditionExpression());
            this.conditionEditor.getViewer().setEditable(true);
        }
    }

    protected void setInputInit() {
        STAlgorithmEmbeddedEditorUtil.updateEditor((EmbeddedEditor)this.conditionEditor, (URI)this.getType().eResource().getURI(), (LibraryElement)this.getBasicFBType(), null, (LibraryElement)IecTypes.ElementaryTypes.BOOL);
    }

    protected void setInputCode() {
        this.commentText.setEnabled(false);
        this.eventCombo.removeAll();
        this.eventCombo.setEnabled(false);
        this.conditionEditor.getViewer().setEditable(false);
    }

    protected void performRefresh() {
        if (this.getBasicFBType() != null) {
            this.fillEventConditionDropdown();
            this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
            if (ECCContentAndLabelProvider.isOneConditionExpression(this.getType())) {
                this.eventCombo.select(this.eventCombo.indexOf("1"));
            } else {
                Event conditionEvent = this.getType().getConditionEvent();
                this.eventCombo.select(conditionEvent != null ? this.getEventIndex(conditionEvent) : this.eventCombo.getItemCount() - 1);
            }
            this.updateConditionEditor();
        }
    }

    private int getEventIndex(Event conditionEvent) {
        return this.eventCombo.indexOf(ECCContentAndLabelProvider.getEventName(conditionEvent));
    }

    public void fillEventConditionDropdown() {
        this.eventCombo.removeAll();
        ECCContentAndLabelProvider.getTransitionConditionEventNames(this.getBasicFBType()).stream().forEach(name -> this.eventCombo.add(name));
    }
}

