/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.MergeStrategyDescriptor;
import org.eclipse.egit.core.internal.MergeStrategies;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class SynchronizePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private RadioGroupFieldEditor preferredMergeStrategyEditor;
    private ScopedPreferenceStore corePreferenceStore;

    public SynchronizePreferencePage() {
        super(0);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("sync_view_fetch_before_launch", UIText.GitPreferenceRoot_fetchBeforeSynchronization, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("sync_view_show_changeset_model", UIText.GitPreferenceRoot_automaticallyEnableChangesetModel, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("enable_logical_model", UIText.GitPreferenceRoot_useLogicalModel, this.getFieldEditorParent()));
        Label spacer = new Label(this.getFieldEditorParent(), 0);
        spacer.setSize(0, 12);
        Composite modelStrategyParent = this.getFieldEditorParent();
        this.preferredMergeStrategyEditor = new RadioGroupFieldEditor("core_preferredMergeStrategy", UIText.GitPreferenceRoot_preferreMergeStrategy_group, 1, this.getAvailableMergeStrategies(), modelStrategyParent, false);
        this.preferredMergeStrategyEditor.getLabelControl(modelStrategyParent).setToolTipText(UIText.GitPreferenceRoot_preferreMergeStrategy_label);
        this.addField((FieldEditor)this.preferredMergeStrategyEditor);
    }

    protected void initialize() {
        super.initialize();
        this.preferredMergeStrategyEditor.setPreferenceStore((IPreferenceStore)this.getCorePreferenceStore());
        this.preferredMergeStrategyEditor.load();
    }

    private String[][] getAvailableMergeStrategies() {
        ArrayList<String[]> strategies = new ArrayList<String[]>();
        strategies.add(new String[]{UIText.GitPreferenceRoot_defaultMergeStrategyLabel, "jgit-default-mergeStrategy"});
        for (MergeStrategyDescriptor strategy : MergeStrategies.getRegisteredMergeStrategies()) {
            strategies.add(new String[]{strategy.getLabel(), strategy.getName()});
        }
        return (String[][])strategies.toArray((T[])new String[0][0]);
    }

    private ScopedPreferenceStore getCorePreferenceStore() {
        if (this.corePreferenceStore == null) {
            this.corePreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.egit.core");
        }
        return this.corePreferenceStore;
    }

    public boolean performOk() {
        if (super.performOk() && this.getCorePreferenceStore().needsSaving()) {
            try {
                this.getCorePreferenceStore().save();
            }
            catch (IOException e) {
                String message = JFaceResources.format((String)"PreferenceDialog.saveErrorMessage", (Object[])new Object[]{this.getTitle(), e.getMessage()});
                Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.jface", message, (Throwable)e), JFaceResources.getString((String)"PreferenceDialog.saveErrorTitle"));
            }
        }
        return true;
    }
}

