/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.contentprovider;

import org.eclipse.fordiac.ide.fbtypeeditor.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.actions.CreateFromNewAdapterAction;
import org.eclipse.fordiac.ide.fbtypeeditor.actions.CreateInputEventAction;
import org.eclipse.fordiac.ide.fbtypeeditor.actions.CreateInputVariableAction;
import org.eclipse.fordiac.ide.fbtypeeditor.actions.CreateInterfaceElementAction;
import org.eclipse.fordiac.ide.fbtypeeditor.actions.CreateNewPlugAction;
import org.eclipse.fordiac.ide.fbtypeeditor.actions.CreateNewSocketAction;
import org.eclipse.fordiac.ide.fbtypeeditor.actions.CreateOutputEventAction;
import org.eclipse.fordiac.ide.fbtypeeditor.actions.CreateOutputVariableAction;
import org.eclipse.fordiac.ide.fbtypeeditor.actions.CreatePlugAction;
import org.eclipse.fordiac.ide.fbtypeeditor.actions.CreateSocketAction;
import org.eclipse.fordiac.ide.gef.FordiacContextMenuProvider;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.typeeditor.TypeEditorInput;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorPart;

public class InterfaceContextMenuProvider
extends FordiacContextMenuProvider {
    private static final String CREATE_PLUG = Messages.InterfaceContextMenuProvider_CreatePlug;
    private static final String CREATE_SOCKET = Messages.InterfaceContextMenuProvider_CreateSocket;
    private final DataTypeLibrary dataTypeLib;

    public InterfaceContextMenuProvider(EditPartViewer viewer, ZoomManager zoomManager, ActionRegistry registry, DataTypeLibrary dataTypeLib) {
        super(viewer, zoomManager, registry);
        this.dataTypeLib = dataTypeLib;
    }

    public void buildContextMenu(IMenuManager menu) {
        super.buildContextMenu(menu);
        IAction action = this.getRegistry().getAction((Object)"org.eclipse.gef.direct_edit");
        if (action != null && action.isEnabled()) {
            menu.appendToGroup("org.eclipse.gef.group.edit", action);
        }
        action = this.getRegistry().getAction((Object)ActionFactory.DELETE.getId());
        menu.appendToGroup("org.eclipse.gef.group.edit", action);
        InterfaceContextMenuProvider.buildInterfaceEditEntries(menu, this.getRegistry(), this.dataTypeLib);
    }

    public static void buildInterfaceEditEntries(IMenuManager menu, ActionRegistry registry, DataTypeLibrary dataTypeLib) {
        Object action = registry.getAction((Object)"InsertInputEventAction");
        menu.appendToGroup("group.add", action);
        IWorkbenchPart part = ((CreateInputEventAction)((Object)action)).getWorkbenchPart();
        FBType fbType = ((CreateInputEventAction)((Object)action)).getFbType();
        action = registry.getAction((Object)"CreateOutputEventAction");
        menu.appendToGroup("group.add", action);
        MenuManager submenu = new MenuManager(Messages.InterfaceContextMenuProvider_CreateDataInput);
        menu.appendToGroup("group.add", (IContributionItem)submenu);
        for (DataType dataType : dataTypeLib.getDataTypesSorted()) {
            action = registry.getAction((Object)CreateInputVariableAction.getID(dataType.getName()));
            if (action == null) {
                action = new CreateInputVariableAction(part, fbType, dataType);
                registry.registerAction(action);
            }
            submenu.add(action);
        }
        submenu = new MenuManager(Messages.InterfaceContextMenuProvider_CreateDataOutput);
        menu.appendToGroup("group.add", (IContributionItem)submenu);
        for (DataType dataType : dataTypeLib.getDataTypesSorted()) {
            action = registry.getAction((Object)CreateOutputVariableAction.getID(dataType.getName()));
            if (action == null) {
                action = new CreateOutputVariableAction(part, fbType, dataType);
                registry.registerAction(action);
            }
            submenu.add(action);
        }
        if (!(fbType instanceof AdapterType)) {
            InterfaceContextMenuProvider.buildAdapterMenuEntries(menu, registry, part, fbType);
        }
    }

    private static void buildAdapterMenuEntries(IMenuManager menu, ActionRegistry registry, IWorkbenchPart part, FBType fbType) {
        TypeEditorInput untypedInput;
        TypeLibrary typeLib;
        IEditorInput iEditorInput = ((EditorPart)part).getEditorInput();
        if (iEditorInput instanceof TypeEditorInput && (typeLib = (untypedInput = (TypeEditorInput)iEditorInput).getTypeEntry().getTypeLibrary()) != null) {
            MenuManager socketEntry = new MenuManager(CREATE_SOCKET);
            menu.appendToGroup("group.add", (IContributionItem)socketEntry);
            MenuManager plugEntry = new MenuManager(CREATE_PLUG);
            menu.appendToGroup("group.add", (IContributionItem)plugEntry);
            Action action = (Action)registry.getAction((Object)"CreateNewPlugAction");
            if (action != null) {
                ((CreateFromNewAdapterAction)action).setTypeEntry(untypedInput.getTypeEntry());
            }
            plugEntry.add((IAction)action);
            action = (Action)registry.getAction((Object)"CreateNewSocketAction");
            if (action != null) {
                ((CreateFromNewAdapterAction)action).setTypeEntry(untypedInput.getTypeEntry());
            }
            socketEntry.add((IAction)action);
            InterfaceContextMenuProvider.fillMenuForPalletteGroup(socketEntry, plugEntry, registry, part, fbType, typeLib);
        }
    }

    private static void fillMenuForPalletteGroup(MenuManager socketEntry, MenuManager plugEntry, ActionRegistry registry, IWorkbenchPart part, FBType fbType, TypeLibrary typeLib) {
        for (AdapterTypeEntry entry : typeLib.getAdapterTypesSorted()) {
            Object action = registry.getAction((Object)CreateSocketAction.getID(entry));
            if (action == null) {
                action = new CreateSocketAction(part, fbType, entry);
            }
            socketEntry.add(action);
            action = registry.getAction((Object)CreatePlugAction.getID(entry));
            if (action == null) {
                action = new CreatePlugAction(part, fbType, entry);
            }
            plugEntry.add(action);
        }
    }

    public static void createInterfaceEditingActions(IWorkbenchPart workBenchPart, ActionRegistry registry, FBType fbType) {
        CreateInterfaceElementAction action = new CreateInputEventAction(workBenchPart, fbType);
        registry.registerAction((IAction)action);
        action = new CreateOutputEventAction(workBenchPart, fbType);
        registry.registerAction((IAction)action);
        if (!(fbType instanceof AdapterType)) {
            action = new CreateNewPlugAction(workBenchPart, fbType);
            registry.registerAction((IAction)action);
            action = new CreateNewSocketAction(workBenchPart, fbType);
            registry.registerAction((IAction)action);
        }
    }
}

