/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.comgeneration.implementation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationChannel;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationChannelDestination;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationMediaInfo;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationModel;
import org.eclipse.fordiac.ide.comgeneration.plugin.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public final class ProtocolSelector {
    private static final String CAN = "Can";
    private static final String ETH = "Ethernet";

    public static void doAutomatedProtocolSelection(CommunicationModel model) {
        for (CommunicationChannel channel : model.getChannels().values()) {
            ArrayList<Segment> commonSegments = new ArrayList<Segment>();
            Iterator<CommunicationChannelDestination> destinationIterator = channel.getDestinations().iterator();
            CommunicationChannelDestination destination = destinationIterator.next();
            for (CommunicationMediaInfo mediaInfo : destination.getAvailableMedia()) {
                commonSegments.add(mediaInfo.getSegment());
            }
            while (destinationIterator.hasNext()) {
                destination = destinationIterator.next();
                Iterator<Segment> segmentIterator = commonSegments.iterator();
                ProtocolSelector.removeSegment(destination, segmentIterator);
            }
            Segment selectedCommonSegment = null;
            if (!commonSegments.isEmpty()) {
                ProtocolSelector.sortSegments(commonSegments);
                selectedCommonSegment = (Segment)commonSegments.get(0);
            }
            destinationIterator = channel.getDestinations().iterator();
            ProtocolSelector.processSegment(destinationIterator, selectedCommonSegment);
        }
    }

    private static void processSegment(Iterator<CommunicationChannelDestination> destinationIterator, Segment selectedCommonSegment) {
        block0: while (destinationIterator.hasNext()) {
            CommunicationChannelDestination destination = destinationIterator.next();
            Segment selectedSegment = selectedCommonSegment;
            if (selectedSegment == null) {
                selectedSegment = ProtocolSelector.createSegment(destination, selectedSegment);
            }
            if (selectedSegment != null) {
                for (CommunicationMediaInfo mediaInfo : destination.getAvailableMedia()) {
                    if (mediaInfo.getSegment() != selectedSegment) continue;
                    destination.setSelectedMedia(mediaInfo);
                    destination.setSelectedProtocolId(ProtocolSelector.getProtocolIdForMetiaType(mediaInfo.getSegment()));
                    continue block0;
                }
                continue;
            }
            FordiacLogHelper.logError((String)Messages.ProtocolSelector_NoConnectionAvailable);
        }
    }

    private static Segment createSegment(CommunicationChannelDestination destination, Segment selectedSegment) {
        ArrayList<Segment> availableSegments = new ArrayList<Segment>();
        for (CommunicationMediaInfo mediaInfo : destination.getAvailableMedia()) {
            availableSegments.add(mediaInfo.getSegment());
        }
        ProtocolSelector.sortSegments(availableSegments);
        if (!availableSegments.isEmpty()) {
            selectedSegment = availableSegments.get(0);
        }
        return selectedSegment;
    }

    private static void removeSegment(CommunicationChannelDestination destination, Iterator<Segment> segmentIterator) {
        while (segmentIterator.hasNext()) {
            Segment segment = segmentIterator.next();
            boolean containsSegment = false;
            for (CommunicationMediaInfo mediaInfo : destination.getAvailableMedia()) {
                if (mediaInfo.getSegment() != segment) continue;
                containsSegment = true;
            }
            if (containsSegment) continue;
            segmentIterator.remove();
        }
    }

    private static String getProtocolIdForMetiaType(Segment segment) {
        if (segment.getType().getName().equalsIgnoreCase(ETH)) {
            return "EthernetPubSub";
        }
        if (segment.getType().getName().equalsIgnoreCase(CAN)) {
            return "CanPubSub";
        }
        return null;
    }

    private static void sortSegments(List<Segment> segmentList) {
        Collections.sort(segmentList, (o1, o2) -> {
            String[] n = ProtocolSelector.getName(o1, o2);
            if (ProtocolSelector.equalETH(n[0]) && ProtocolSelector.equalCAN(n[1])) {
                return 1;
            }
            if (!ProtocolSelector.equalCAN(n[1]) && (ProtocolSelector.equalCAN(n[0]) || ProtocolSelector.equalETH(n[0]) && !ProtocolSelector.equalETH(n[1]))) {
                return -1;
            }
            return 0;
        });
    }

    private static boolean equalETH(String str) {
        return str.equalsIgnoreCase(ETH);
    }

    private static boolean equalCAN(String str) {
        return str.equalsIgnoreCase(CAN);
    }

    private static String[] getName(Segment o1, Segment o2) {
        String[] name = new String[]{o1.getType().getName(), o2.getType().getName()};
        return name;
    }

    private ProtocolSelector() {
        throw new UnsupportedOperationException("ProtocolSelector utility class should not be instantiated!");
    }
}

