/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import java.util.function.Supplier;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.ui.Messages;
import org.eclipse.fordiac.ide.model.ui.editors.DataTypeTreeSelectionDialog;
import org.eclipse.fordiac.ide.model.ui.nat.TypeNode;
import org.eclipse.fordiac.ide.model.ui.widgets.ITypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.TypeSelectionProposalProvider;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DataTypeDropdown
extends TextCellEditor {
    private ContentProposalAdapter adapter;
    private Text textControl;
    private final Supplier<TypeLibrary> supplier;
    private final ITypeSelectionContentProvider contentProvider;
    private final ITreeContentProvider treeContentProvider;
    private final TableViewer viewer;
    private boolean isTraverseNextProcessActive;
    private boolean isTraversePreviousProcessActive;
    static final char[] ACTIVATION_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '.', '\b'};

    public DataTypeDropdown(Supplier<TypeLibrary> supplier, ITypeSelectionContentProvider contentProvider, ITreeContentProvider treeContentProvider, TableViewer viewer) {
        super((Composite)viewer.getTable());
        this.supplier = supplier;
        this.contentProvider = contentProvider;
        this.treeContentProvider = treeContentProvider;
        this.viewer = viewer;
        this.configureTextControl();
        this.createDialogButton();
        this.enableContentProposal();
    }

    protected void doSetValue(Object value) {
        if (value == null) {
            this.textControl.setText("");
        } else {
            super.doSetValue(value);
        }
    }

    protected Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout contLayout = new GridLayout(2, false);
        contLayout.horizontalSpacing = 0;
        contLayout.marginTop = 0;
        contLayout.marginBottom = 0;
        contLayout.marginWidth = 0;
        contLayout.marginHeight = 0;
        contLayout.verticalSpacing = 0;
        contLayout.horizontalSpacing = 0;
        container.setLayout((Layout)contLayout);
        this.textControl = (Text)super.createControl(container);
        return container;
    }

    private void configureTextControl() {
        this.textControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.textControl.addListener(31, e -> {
            e.doit = false;
            if (e.detail == 16 && (e.stateMask & 0x40000) != 0) {
                int selIndex = this.viewer.getTable().getSelectionIndex() + 1;
                if (selIndex < this.viewer.getTable().getItemCount()) {
                    Object data = this.viewer.getTable().getItem(selIndex).getData();
                    this.viewer.editElement(data, 1);
                }
            } else if (e.detail == 8 && (e.stateMask & 0x40000) != 0) {
                int selIndex = this.viewer.getTable().getSelectionIndex() - 1;
                if (selIndex >= 0) {
                    Object data = this.viewer.getTable().getItem(selIndex).getData();
                    this.viewer.editElement(data, 1);
                }
            } else if (e.detail == 16) {
                if (this.adapter.isProposalPopupOpen()) {
                    DataTypeDropdown.triggerEnterKeyEvent();
                    this.isTraverseNextProcessActive = true;
                } else {
                    this.traverseToNextCell();
                }
            } else if (e.detail == 8) {
                if (this.adapter.isProposalPopupOpen()) {
                    DataTypeDropdown.triggerEnterKeyEvent();
                    this.isTraversePreviousProcessActive = true;
                } else {
                    this.traverseToPreviousCell();
                }
            }
        });
    }

    private static void triggerEnterKeyEvent() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        Event event = new Event();
        event.keyCode = 13;
        event.display = display;
        event.type = 1;
        display.post(event);
    }

    private void traverseToPreviousCell() {
        int selIndex = this.viewer.getTable().getSelectionIndex();
        Object data = this.viewer.getTable().getItem(selIndex).getData();
        this.adapter.setEnabled(false);
        this.viewer.editElement(data, 0);
        this.adapter.setEnabled(true);
    }

    private void traverseToNextCell() {
        int selIndex = this.viewer.getTable().getSelectionIndex();
        Object data = this.viewer.getTable().getItem(selIndex).getData();
        this.adapter.setEnabled(false);
        this.viewer.editElement(data, 2);
        this.adapter.setEnabled(true);
    }

    private void createDialogButton() {
        Button menuButton = new Button((Composite)this.getControl(), 0x800000);
        menuButton.setText("...");
        menuButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeDropdown.this.openDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void openDialog() {
        TypeNode node;
        DataTypeTreeSelectionDialog dialog = new DataTypeTreeSelectionDialog(this.getControl().getShell(), this.treeContentProvider);
        dialog.setInput(this.supplier.get());
        dialog.setTitle(Messages.DataTypeDropdown_Type_Selection);
        dialog.setMessage(Messages.DataTypeDropdown_Select_Type);
        dialog.setDoubleClickSelects(false);
        dialog.setHelpAvailable(false);
        if (dialog.open() != 0) {
            this.deactivate();
            return;
        }
        Object result = dialog.getFirstResult();
        if (result instanceof TypeNode && !(node = (TypeNode)result).isDirectory()) {
            this.doSetValue(node.getFullName());
            this.fireApplyEditorValue();
        }
        this.deactivate();
    }

    private void enableContentProposal() {
        this.adapter = new ContentProposalAdapter((Control)this.text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new TypeSelectionProposalProvider(this.supplier, this.contentProvider), null, ACTIVATION_CHARS);
        this.adapter.addContentProposalListener(proposal -> {
            this.fireApplyEditorValue();
            if (this.isTraverseNextProcessActive) {
                this.traverseToNextCell();
                this.isTraverseNextProcessActive = false;
            } else if (this.isTraversePreviousProcessActive) {
                this.traverseToPreviousCell();
                this.isTraversePreviousProcessActive = false;
            }
        });
        this.adapter.setProposalAcceptanceStyle(2);
    }

    protected void focusLost() {
        if (!this.insideAnyEditorArea()) {
            this.deactivate();
        }
    }

    private boolean insideAnyEditorArea() {
        Point cursorLocation = this.getControl().getDisplay().getCursorLocation();
        Point containerRelativeCursor = this.getControl().getParent().toControl(cursorLocation);
        return this.getControl().getBounds().contains(containerRelativeCursor);
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }
}

