package ONVIF::PTZ::Types::OSDTextConfiguration;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Type_of :ATTR(:get<Type>);
my %DateFormat_of :ATTR(:get<DateFormat>);
my %TimeFormat_of :ATTR(:get<TimeFormat>);
my %FontSize_of :ATTR(:get<FontSize>);
my %FontColor_of :ATTR(:get<FontColor>);
my %BackgroundColor_of :ATTR(:get<BackgroundColor>);
my %PlainText_of :ATTR(:get<PlainText>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Type
        DateFormat
        TimeFormat
        FontSize
        FontColor
        BackgroundColor
        PlainText
        Extension

    ) ],
    {
        'Type' => \%Type_of,
        'DateFormat' => \%DateFormat_of,
        'TimeFormat' => \%TimeFormat_of,
        'FontSize' => \%FontSize_of,
        'FontColor' => \%FontColor_of,
        'BackgroundColor' => \%BackgroundColor_of,
        'PlainText' => \%PlainText_of,
        'Extension' => \%Extension_of,
    },
    {
        'Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'DateFormat' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'TimeFormat' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'FontSize' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'FontColor' => 'ONVIF::PTZ::Types::OSDColor',
        'BackgroundColor' => 'ONVIF::PTZ::Types::OSDColor',
        'PlainText' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Extension' => 'ONVIF::PTZ::Types::OSDTextConfigurationExtension',
    },
    {

        'Type' => 'Type',
        'DateFormat' => 'DateFormat',
        'TimeFormat' => 'TimeFormat',
        'FontSize' => 'FontSize',
        'FontColor' => 'FontColor',
        'BackgroundColor' => 'BackgroundColor',
        'PlainText' => 'PlainText',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::OSDTextConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
OSDTextConfiguration from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Type


=item * DateFormat


=item * TimeFormat


=item * FontSize


=item * FontColor


=item * BackgroundColor


=item * PlainText


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::OSDTextConfiguration
   Type =>  $some_value, # string
   DateFormat =>  $some_value, # string
   TimeFormat =>  $some_value, # string
   FontSize =>  $some_value, # int
   FontColor =>  { # ONVIF::PTZ::Types::OSDColor
     Color => ,
   },
   BackgroundColor =>  { # ONVIF::PTZ::Types::OSDColor
     Color => ,
   },
   PlainText =>  $some_value, # string
   Extension =>  { # ONVIF::PTZ::Types::OSDTextConfigurationExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

