/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.firebirdsql.ds.RootCommonDataSource;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.jaybird.xca.FBConnectionRequestInfo;
import org.firebirdsql.jaybird.xca.FBManagedConnectionFactory;
import org.firebirdsql.jaybird.xca.XcaConnectionManager;

public class FBDataSource
extends RootCommonDataSource
implements DataSource,
Serializable {
    private static final long serialVersionUID = 1178461472062969634L;
    private final XcaConnectionManager cm;
    private final FBManagedConnectionFactory mcf;
    private int loginTimeout = 0;

    public FBDataSource(FBManagedConnectionFactory mcf, XcaConnectionManager cm) {
        this.mcf = mcf;
        this.cm = cm;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.cm.allocateConnection(this.mcf, this.mcf.getDefaultConnectionRequestInfo());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        FBConnectionRequestInfo subjectCri = this.mcf.getDefaultConnectionRequestInfo();
        subjectCri.setUserName(username);
        subjectCri.setPassword(password);
        return this.cm.allocateConnection(this.mcf, subjectCri);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw FbExceptionBuilder.forException(337248338).messageParameter((Object)(iface != null ? iface.getName() : "(null)")).toSQLException();
        }
        return iface.cast(this);
    }
}

