/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class VaxEncoding {
    private VaxEncoding() {
    }

    public static int iscVaxInteger(byte[] buf, int off, int len) {
        if (len > 4) {
            return 0;
        }
        int value = 0;
        int shift = 0;
        while (--len >= 0) {
            value += (buf[off++] & 0xFF) << shift;
            shift += 8;
        }
        return value;
    }

    public static void encodeVaxInteger(OutputStream out, int val) throws IOException {
        byte[] buf = new byte[5];
        VaxEncoding.encodeVaxInteger(buf, 0, val);
        out.write(buf, 0, 5);
    }

    public static void encodeVaxInteger(byte[] buf, int off, int val) {
        buf[off++] = 4;
        VaxEncoding.encodeVaxIntegerWithoutLength(buf, off, val);
    }

    public static void encodeVaxIntegerWithoutLength(OutputStream out, int val) throws IOException {
        byte[] buf = new byte[4];
        VaxEncoding.encodeVaxIntegerWithoutLength(buf, 0, val);
        out.write(buf, 0, 4);
    }

    public static void encodeVaxIntegerWithoutLength(byte[] buf, int off, int val) {
        buf[off++] = (byte)val;
        buf[off++] = (byte)(val >>> 8);
        buf[off++] = (byte)(val >>> 16);
        buf[off] = (byte)(val >>> 24);
    }

    public static long iscVaxLong(byte[] buf, int off, int len) {
        if (len > 8) {
            return 0L;
        }
        long value = 0L;
        int shift = 0;
        while (--len >= 0) {
            value += ((long)buf[off++] & 0xFFL) << shift;
            shift += 8;
        }
        return value;
    }

    public static void encodeVaxLong(OutputStream out, long val) throws IOException {
        byte[] buf = new byte[9];
        VaxEncoding.encodeVaxLong(buf, 0, val);
        out.write(buf, 0, 9);
    }

    public static void encodeVaxLong(byte[] buf, int off, long val) {
        buf[off++] = 8;
        VaxEncoding.encodeVaxLongWithoutLength(buf, off, val);
    }

    public static void encodeVaxLongWithoutLength(OutputStream out, long val) throws IOException {
        byte[] buf = new byte[8];
        VaxEncoding.encodeVaxLongWithoutLength(buf, 0, val);
        out.write(buf, 0, 8);
    }

    public static void encodeVaxLongWithoutLength(byte[] buf, int off, long val) {
        buf[off++] = (byte)val;
        buf[off++] = (byte)(val >>> 8);
        buf[off++] = (byte)(val >>> 16);
        buf[off++] = (byte)(val >>> 24);
        buf[off++] = (byte)(val >>> 32);
        buf[off++] = (byte)(val >>> 40);
        buf[off++] = (byte)(val >>> 48);
        buf[off] = (byte)(val >>> 56);
    }

    public static int iscVaxInteger2(byte[] buf, int off) {
        return buf[off] & 0xFF | (buf[off + 1] & 0xFF) << 8;
    }

    public static void encodeVaxInteger2WithoutLength(OutputStream out, int val) throws IOException {
        out.write(val);
        out.write(val >>> 8);
    }

    public static void encodeVaxInteger2WithoutLength(byte[] buf, int off, int val) {
        buf[off++] = (byte)val;
        buf[off] = (byte)(val >>> 8);
    }

    public static int decodeVaxInteger2WithoutLength(InputStream in) throws IOException {
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return ch1 | ch2 << 8;
    }
}

