
# 11 "plugins/derive/g_derive.mlg"
 

open Stdarg


# 9 "plugins/derive/g_derive.ml"

let _ = Mltop.add_known_module "rocq-runtime.plugins.derive"

# 19 "plugins/derive/g_derive.mlg"
 

let classify_derive_command _ = Vernacextend.(VtStartProof (Doesn'tGuaranteeOpacity,[]))

let () =
   Mltop.add_init_function "rocq-runtime.plugins.derive" (fun () ->
     Procq.modify_keyword_state (fun kw -> CLexer.add_keyword_tok kw (Tok.PKEYWORD "SuchThat")))

let warn_deprecated_derive_suchthat =
   CWarnings.create ~name:"deprecated-derive-suchthat" ~category:Deprecation.Version.v9_0
  (fun () -> Pp.strbrk "Use of \"SuchThat\" and \"As\" in \"Derive\" is deprecated; replace them respectively by \"in\" and \"as\".")


# 27 "plugins/derive/g_derive.ml"

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.derive") ~command:"Derive" ~classifier:(fun ~atts ->  classify_derive_command ) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Derive",
           Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_open_binders),
           Vernacextend.TyTerminal
           ("SuchThat",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyTerminal
            ("As",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
             Vernacextend.TyNil)))))),
          (let coqpp_body bl suchthat lemma atts =
            Vernactypes.vtopenproof (fun () -> (
# 36 "plugins/derive/g_derive.mlg"
    warn_deprecated_derive_suchthat ();
    Derive.start_deriving ~atts bl suchthat lemma 
# 47 "plugins/derive/g_derive.ml"
)) in
            fun bl suchthat lemma ?loc ~atts () ->
            coqpp_body bl suchthat lemma (Attributes.parse 
# 34 "plugins/derive/g_derive.mlg"
             Vernacentries.DefAttributes.def_attributes
# 53 "plugins/derive/g_derive.ml"
 atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Derive",
           Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_open_binders),
           Vernacextend.TyTerminal
           ("in",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr),
            Vernacextend.TyTerminal
            ("as",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
             Vernacextend.TyNil)))))),
          (let coqpp_body bl suchthat lemma atts =
            Vernactypes.vtopenproof (fun () -> (
# 40 "plugins/derive/g_derive.mlg"
    Derive.start_deriving ~atts bl suchthat lemma 
# 72 "plugins/derive/g_derive.ml"
)) in
            fun bl suchthat lemma ?loc ~atts () ->
            coqpp_body bl suchthat lemma (Attributes.parse 
# 38 "plugins/derive/g_derive.mlg"
             Vernacentries.DefAttributes.def_attributes
# 78 "plugins/derive/g_derive.ml"
 atts)),
          None))]

